/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.domain.mointer;

import com.bxm.localnews.base.service.domain.mointer.heartbeat.DomainHeartbeat;
import com.bxm.localnews.common.constant.DomainScene;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MoniterService {
    private static final Logger log = LoggerFactory.getLogger(MoniterService.class);
    private List<DomainHeartbeat> domainHeartbeatList;
    private Map<DomainScene, DomainHeartbeat> domainSceneDomainHeartbeatMap = Maps.newHashMap();

    public MoniterService(List<DomainHeartbeat> domainHeartbeatList) {
        this.domainHeartbeatList = domainHeartbeatList;
    }

    @PostConstruct
    public void init() {
        this.domainHeartbeatList.forEach(p -> this.domainSceneDomainHeartbeatMap.put(p.support(), (DomainHeartbeat)p));
    }

    public boolean checkBaseUrlAvailable(String baseUrl, DomainScene scene) {
        DomainHeartbeat heartbeat = this.domainSceneDomainHeartbeatMap.get(scene);
        if (Objects.isNull(heartbeat)) {
            log.warn("\u57df\u540d\u7c7b\u578b: {} \u6ca1\u6709\u5bf9\u5e94\u7684\u5904\u7406\u7c7b", (Object)scene);
            return false;
        }
        return heartbeat.ping(baseUrl);
    }
}

