/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.config.DomainConfig;
import com.bxm.localnews.base.config.SpecialUrlConfig;
import com.bxm.localnews.base.domain.BaseDomainPublishExtendMapper;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.base.service.domain.SceneBaseUrlJoiner;
import com.bxm.localnews.base.service.impl.BaseUrlService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.entity.DomainInfo;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.param.GetViewSceneDomainInfoParam;
import com.bxm.localnews.common.param.SelectAvailableDomainBySceneParam;
import com.bxm.localnews.common.vo.BaseUrlInfo;
import com.bxm.localnews.common.vo.ViewSceneBaseUrl;
import com.bxm.localnews.common.vo.ViewSceneInfo;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.gexin.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BaseUrlServiceImpl
implements BaseUrlService,
BaseUrlFacadeService {
    private static final Logger log = LoggerFactory.getLogger(BaseUrlServiceImpl.class);
    private final BaseDomainPublishExtendMapper baseDomainPublishExtendMapper;
    private final SceneBaseUrlJoiner sceneBaseUrlJoiner;
    private final DomainConfig domainConfig;
    private final SpecialUrlConfig specialUrlConfig;
    private final MessageSender messageSender;
    private final SequenceCreater sequenceCreater;
    private LoadingCache<SelectAvailableDomainBySceneParam, List<DomainInfo>> CACHE;

    public BaseUrlServiceImpl(BaseDomainPublishExtendMapper baseDomainPublishExtendMapper, SceneBaseUrlJoiner sceneBaseUrlJoiner, DomainConfig domainConfig, SpecialUrlConfig specialUrlConfig, MessageSender messageSender, SequenceCreater sequenceCreater) {
        this.baseDomainPublishExtendMapper = baseDomainPublishExtendMapper;
        this.sceneBaseUrlJoiner = sceneBaseUrlJoiner;
        this.domainConfig = domainConfig;
        this.specialUrlConfig = specialUrlConfig;
        this.messageSender = messageSender;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public BaseUrlInfo getBaseUrlInfo(GetAvailableDomainInfoParam param) {
        return this.getBaseUrlByScene(param).orElse(BaseUrlInfo.builder().baseUrl(this.domainConfig.getDefaultBaseUrl().get(param.getScene())).build());
    }

    public ViewSceneBaseUrl getBaseUrlByViewScene(GetViewSceneDomainInfoParam param) {
        try {
            Optional<DomainInfo> domainInfoOpt;
            Optional domainScene = DomainScene.DomainViewScene.forName((String)param.getViewScene());
            if (!domainScene.isPresent()) {
                return new ViewSceneBaseUrl();
            }
            List<DomainInfo> domainInfos = this.selectAvailableDomainBySceneByCache(DomainScene.OUTSIDE_SHARE_VIEW.getScene(), ((DomainScene.DomainViewScene)domainScene.get()).getScene(), param.getAppId());
            if (param.isExclusionViewScene()) {
                domainInfos.removeIf(p -> !CollectionUtils.isEmpty(this.domainConfig.getExclusionViewSceneDomains()) && this.domainConfig.getExclusionViewSceneDomains().contains(p.getDomain()));
            }
            if (!(domainInfoOpt = this.getRandomInfo(domainInfos)).isPresent()) {
                String msg = String.format("\u3010\u7d27\u6025\u3011\u7c7b\u578b: %s\u83b7\u53d6\u4e0d\u5230\u53ef\u7528\u7684\u843d\u5730\u9875\u57df\u540d \u4e8b\u4ef6id: %s ", param.getViewScene(), this.sequenceCreater.nextStringId());
                this.messageSender.sendDingtalk(DingtalkMessage.builder().content(msg).build());
                log.warn(msg + "param: {}", (Object)JSON.toJSONString((Object)param));
                return new ViewSceneBaseUrl();
            }
            DomainInfo domainInfo = domainInfoOpt.get();
            ViewSceneBaseUrl domain = new ViewSceneBaseUrl();
            domain.setDomain(domainInfo.getDomain());
            domain.setBaseUrl(this.sceneBaseUrlJoiner.joinByScene(DomainScene.OUTSIDE_SHARE_VIEW, null, StringUtils.join((Object[])new String[]{domainInfo.getProtocol(), domainInfo.getDomain()})));
            domain.setViewScene(Objects.toString(domainScene));
            return domain;
        }
        catch (Exception e) {
            String msg = String.format("\u3010\u7d27\u6025\u3011\u7c7b\u578b: %s\u83b7\u53d6\u53ef\u7528\u7684\u843d\u5730\u9875\u57df\u540d\u51fa\u9519\u8bef\u4e86 \u4e8b\u4ef6id: %s ", param.getViewScene(), this.sequenceCreater.nextStringId());
            this.messageSender.sendDingtalk(DingtalkMessage.builder().content(msg).build());
            log.error(msg + "param: {}", (Object)JSON.toJSONString((Object)param), (Object)e);
            return new ViewSceneBaseUrl();
        }
    }

    public List<ViewSceneInfo> getViewSceneByDomain(String domain) {
        List domainInfos = this.baseDomainPublishExtendMapper.getViewSceneByDomain(domain);
        return domainInfos.stream().map(this::convert).collect(Collectors.toList());
    }

    public String getShortLinkBaseUrl() {
        return this.getByScene(DomainScene.SHORT);
    }

    public String getInnerH5BaseUrl() {
        return this.getByScene(DomainScene.INNER_H5);
    }

    public String getOutSideShareBaseUrl(DomainScene.DomainViewScene viewScene) {
        GetAvailableDomainInfoParam param = new GetAvailableDomainInfoParam();
        param.setScene(Objects.toString(DomainScene.OUTSIDE_SHARE));
        param.setViewScene(Objects.toString(viewScene));
        Optional<BaseUrlInfo> baseUrlByScene = this.getBaseUrlByScene(param);
        return baseUrlByScene.isPresent() ? baseUrlByScene.get().getBaseUrl() : "";
    }

    public String getDownloadYYBUrl() {
        return this.specialUrlConfig.getDownloadYYBUrl();
    }

    public String getAppIconUrl() {
        return this.specialUrlConfig.getAppIconUrl();
    }

    public String getContentViewSceneBaseUrl() {
        GetViewSceneDomainInfoParam param = new GetViewSceneDomainInfoParam();
        param.setViewScene(Objects.toString(DomainScene.DomainViewScene.CONTENT_VIEW));
        return this.getBaseUrlByViewScene(param).getBaseUrl();
    }

    public String getDownloadUrl() {
        return StringUtils.join((Object[])new String[]{this.getContentViewSceneBaseUrl(), this.specialUrlConfig.getDownload()});
    }

    public String getServerHostBaseUrl() {
        return this.getByScene(DomainScene.SERVER_HOST);
    }

    private Optional<BaseUrlInfo> getBaseUrlByScene(GetAvailableDomainInfoParam param) {
        try {
            Optional domainScene = DomainScene.forName((String)param.getScene());
            if (!domainScene.isPresent()) {
                log.warn("\u8bf7\u6c42\u53c2\u6570: {} \u7684\u573a\u666f\u503c\u4e0d\u5b58\u5728 \u65e0\u6cd5\u83b7\u53d6\u57df\u540d\u4fe1\u606f", (Object)JSON.toJSONString((Object)param));
                return Optional.empty();
            }
            Optional domainViewScene = DomainScene.DomainViewScene.forName((String)param.getViewScene());
            if (Objects.equals(domainScene.get(), DomainScene.OUTSIDE_SHARE_VIEW) && !domainViewScene.isPresent()) {
                log.warn("\u8bf7\u6c42\u53c2\u6570: {} \u7684\u843d\u5730\u9875\u573a\u666f\u503c\u4e0d\u5b58\u5728 \u65e0\u6cd5\u83b7\u53d6\u57df\u540d\u4fe1\u606f", (Object)JSON.toJSONString((Object)param));
                return Optional.empty();
            }
            List<DomainInfo> domainInfos = this.selectAvailableDomainBySceneByCache(((DomainScene)domainScene.get()).getScene(), null, param.getAppId());
            Optional<DomainInfo> domainInfoOpt = this.getRandomInfo(domainInfos);
            if (!domainInfoOpt.isPresent()) {
                String msg = String.format("\u3010\u7d27\u6025\u3011\u7c7b\u578b: %s\u83b7\u53d6\u4e0d\u5230\u53ef\u7528\u7684\u57df\u540d \u4e8b\u4ef6id: %s ", param.getScene(), this.sequenceCreater.nextStringId());
                this.messageSender.sendDingtalk(DingtalkMessage.builder().content(msg).build());
                log.warn(msg + "param: {}", (Object)JSON.toJSONString((Object)param));
                return Optional.empty();
            }
            DomainInfo domainInfo = domainInfoOpt.get();
            BaseUrlInfo info = new BaseUrlInfo();
            info.setDomain(domainInfo.getDomain());
            info.setBaseUrl(this.sceneBaseUrlJoiner.joinByScene((DomainScene)domainScene.get(), domainViewScene.orElse(null), StringUtils.join((Object[])new String[]{domainInfo.getProtocol(), domainInfo.getDomain()})));
            if (log.isDebugEnabled()) {
                log.debug("param: {} \u6700\u7ec8\u83b7\u53d6\u5230\u7684base url\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)info));
            }
            return Optional.of(info);
        }
        catch (Exception e) {
            String msg = String.format("\u3010\u7d27\u6025\u3011\u7c7b\u578b: %s\u83b7\u53d6\u53ef\u7528\u7684\u57df\u540d\u51fa\u9519\u8bef\u4e86 \u4e8b\u4ef6id: %s ", param.getScene(), this.sequenceCreater.nextStringId());
            this.messageSender.sendDingtalk(DingtalkMessage.builder().content(msg).build());
            log.error(msg + "param: {}", (Object)JSON.toJSONString((Object)param), (Object)e);
            return Optional.empty();
        }
    }

    private Optional<DomainInfo> getRandomInfo(List<DomainInfo> domainInfos) {
        if (domainInfos.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(domainInfos.get(RandomUtils.nextInt((int)0, (int)domainInfos.size())));
    }

    private ViewSceneInfo convert(DomainInfo domainInfo) {
        ViewSceneInfo info = new ViewSceneInfo();
        Optional domainViewScene = DomainScene.DomainViewScene.forViewScene((byte)domainInfo.getViewScene());
        info.setDomain(domainInfo.getDomain());
        info.setProtocol(domainInfo.getProtocol());
        info.setViewScene(domainViewScene.isPresent() ? Objects.toString(domainViewScene.get()) : "");
        info.setAppId(domainInfo.getAppId());
        return info;
    }

    private String getByScene(DomainScene scene) {
        GetAvailableDomainInfoParam param = new GetAvailableDomainInfoParam();
        param.setScene(Objects.toString(scene));
        BaseUrlInfo domainInfo = this.getBaseUrlInfo(param);
        return domainInfo.getBaseUrl();
    }

    private List<DomainInfo> selectAvailableDomainBySceneByCache(byte scene, Byte viewScene, String appId) {
        SelectAvailableDomainBySceneParam param = new SelectAvailableDomainBySceneParam();
        param.setScene(scene);
        param.setViewScene(viewScene);
        param.setAppId(appId);
        return this.selectAvailableDomainBySceneByCache(param);
    }

    private List<DomainInfo> selectAvailableDomainBySceneByCache(SelectAvailableDomainBySceneParam param) {
        if (Objects.isNull(this.CACHE)) {
            this.CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<SelectAvailableDomainBySceneParam, List<DomainInfo>>(){

                public List<DomainInfo> load(SelectAvailableDomainBySceneParam sceneParam) throws Exception {
                    return BaseUrlServiceImpl.this.baseDomainPublishExtendMapper.selectAvailableDomainByScene(sceneParam.getScene(), sceneParam.getViewScene(), sceneParam.getAppId());
                }
            });
        }
        if (!Objects.equals(this.domainConfig.getCacheSwitch(), Boolean.TRUE)) {
            this.CACHE.refresh((Object)param);
        }
        return (List)this.CACHE.getUnchecked((Object)param);
    }
}

