/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.domain.AreaCodeMapper;
import com.bxm.localnews.base.domain.AreaDivisionMapper;
import com.bxm.localnews.base.domain.LocationMapper;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.CustomerServiceDTO;
import com.bxm.localnews.common.dto.GroupCustomerPhoneDTO;
import com.bxm.localnews.common.dto.LocationDTO;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.dto.OfficialAccountDTO;
import com.bxm.localnews.common.param.ListAreaLocationParam;
import com.bxm.localnews.common.param.LocationDetailCacheParam;
import com.bxm.localnews.common.vo.AreaCode;
import com.bxm.localnews.common.vo.AreaDivision;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Location;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.LocationUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationServiceImpl
extends BaseService
implements LocationService,
LocationFacadeService {
    private static final Logger LOG = LoggerFactory.getLogger(LocationServiceImpl.class);
    private static final int AREA_CODE_LENGTH = 12;
    private static final int AREA_CODE_HALF_LENGTH = 6;
    private final AreaCodeMapper areaCodeMapper;
    private final AreaDivisionMapper areaDivisionMapper;
    private final LocationMapper locationMapper;
    private final BizConfigProperties bizConfigProperties;
    private final UserIntegrationService userIntegrationService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private LoadingCache<KeyGenerator, List<LocationDTO>> cache;
    private LoadingCache<LocationDetailCacheParam, LocationDetailDTO> singleCache;

    @Autowired
    public LocationServiceImpl(AreaCodeMapper areaCodeMapper, AreaDivisionMapper areaDivisionMapper, LocationMapper locationMapper, BizConfigProperties bizConfigProperties, UserIntegrationService userIntegrationService, RedisHashMapAdapter redisHashMapAdapter) {
        this.areaCodeMapper = areaCodeMapper;
        this.areaDivisionMapper = areaDivisionMapper;
        this.locationMapper = locationMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.userIntegrationService = userIntegrationService;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public AreaCode selectByAreaName(String name, String province) {
        List areaCodeList = this.areaCodeMapper.selectByAreaName(province);
        if (areaCodeList != null) {
            for (AreaCode areaCode : areaCodeList) {
                String codeSplit;
                List areaList;
                String tail = areaCode.getAreaCode().substring(2, 6);
                if (!"0000".equalsIgnoreCase(tail) || (areaList = this.areaCodeMapper.selectByAreaCode(name, codeSplit = areaCode.getAreaCode().substring(0, 2))) == null) continue;
                return (AreaCode)areaList.get(0);
            }
        }
        return null;
    }

    @PostConstruct
    public void init() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(3000L).build((CacheLoader)new CacheLoader<KeyGenerator, List<LocationDTO>>(){

            public List<LocationDTO> load(KeyGenerator key) {
                if (RedisConfig.HOT_LOCATION.equals(key)) {
                    return LocationServiceImpl.this.listHotLocation();
                }
                if (RedisConfig.OPERATION_LOCATION.equals(key)) {
                    return LocationServiceImpl.this.listOperationLocation();
                }
                return LocationServiceImpl.this.listOpenedLocation();
            }
        });
        this.singleCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(3000L).build((CacheLoader)new CacheLoader<LocationDetailCacheParam, LocationDetailDTO>(){

            public LocationDetailDTO load(LocationDetailCacheParam param) {
                if (LocationServiceImpl.this.logger.isDebugEnabled()) {
                    LocationServiceImpl.this.logger.debug("\u6839\u636ecode\u83b7\u53d6\u57ce\u5e02\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)param));
                }
                String code = param.getCode();
                LocationDetailDTO locationDTO = new LocationDetailDTO();
                locationDTO.setCode(code);
                if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)code)) {
                    if (12 == code.length() && null == (locationDTO = LocationServiceImpl.this.getLocationDetailByCode(code, param.isLastCodeQuery()))) {
                        code = code.substring(0, 6);
                    }
                    if (6 == code.length()) {
                        String fullCode = code + "000000";
                        LocationDetailDTO locationDTOTemp = LocationServiceImpl.this.getLocationDetailByCode(fullCode, param.isLastCodeQuery());
                        if (Objects.isNull(locationDTOTemp)) {
                            if (param.isQueryParent()) {
                                fullCode = code.substring(0, 4) + "00000000";
                                locationDTO = LocationServiceImpl.this.getLocationDetailByCode(fullCode);
                            }
                        } else {
                            locationDTO = locationDTOTemp;
                        }
                    }
                }
                return locationDTO;
            }
        });
    }

    @Override
    public LocationMeta listLocation(ListAreaLocationParam param) {
        Long userId = param.getUserId();
        LocationMeta locationMeta = new LocationMeta();
        locationMeta.setOpenedLocation((List)this.cache.getUnchecked((Object)RedisConfig.OPENED_LOCATION));
        if (Objects.isNull(param.getLat()) || Objects.isNull(param.getLon())) {
            locationMeta.setHotLocation((List)this.cache.getUnchecked((Object)RedisConfig.HOT_LOCATION));
        } else {
            locationMeta.setHotLocation(((List)this.cache.getUnchecked((Object)RedisConfig.OPERATION_LOCATION)).stream().sorted((p1, p2) -> {
                double l1 = LocationUtils.getDistance((double)param.getLat(), (double)param.getLon(), (double)p1.getLat(), (double)p1.getLng());
                double l2 = LocationUtils.getDistance((double)param.getLat(), (double)param.getLon(), (double)p2.getLat(), (double)p2.getLng());
                p1.setDistance(Double.valueOf(l1));
                p2.setDistance(Double.valueOf(l2));
                return Double.compare(l1, l2);
            }).limit(this.bizConfigProperties.getMaxNearbyCityRecommendNum().intValue()).collect(Collectors.toList()));
        }
        if (null != userId) {
            UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
            if (null != userInfoDTO && null != userInfoDTO.getHometownCode()) {
                LocationDTO locationDTO = new LocationDTO();
                locationDTO.setCode(userInfoDTO.getHometownCode());
                LocationDetailDTO location = (LocationDetailDTO)this.singleCache.getUnchecked((Object)LocationDetailCacheParam.builder().code(userInfoDTO.getHometownCode()).build());
                locationDTO.setName(location.getName());
                locationMeta.setHometown(locationDTO);
            } else {
                this.logger.warn("\u83b7\u53d6\u57ce\u5e02\u4fe1\u606f\u65f6\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", (Object)userId);
            }
        }
        return locationMeta;
    }

    @Override
    public List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode) {
        AreaDivision areaDivisionParam = new AreaDivision();
        areaDivisionParam.setParentCode(parentCode);
        List areaDivisionList = this.areaDivisionMapper.selectByModel(areaDivisionParam);
        return areaDivisionList.stream().map(this::convertDivision).collect(Collectors.toList());
    }

    @Override
    public LocationDetailDTO getInternalLocationByGeocode(String code, BasicParam basicParam) {
        return this.getInternalLocationByGeocode(code, basicParam, true, true, true);
    }

    @Override
    public LocationDetailDTO getInternalLocationByGeocode(String code, BasicParam basicParam, boolean queryParent, boolean queryDefault, boolean lastCodeQuery) {
        LocationDetailDTO locationInfo = (LocationDetailDTO)this.singleCache.getUnchecked((Object)LocationDetailCacheParam.builder().code(code).queryParent(queryParent).lastCodeQuery(lastCodeQuery).build());
        if (null == locationInfo || StringUtils.isBlank((CharSequence)locationInfo.getName())) {
            this.logger.warn("\u7528\u6237\u5b9a\u4f4d\u5931\u8d25, \u662f\u5426\u586b\u5145\u9ed8\u8ba4\u5b9a\u4f4d\u57ce\u5e02: {}, [{}}],\u539f\u57ce\u5e02:[{}],\u53c2\u6570:[{}]", new Object[]{queryDefault, this.bizConfigProperties.getLocationCode(), code, JSON.toJSON((Object)basicParam)});
            if (queryDefault) {
                locationInfo = (LocationDetailDTO)this.singleCache.getUnchecked((Object)LocationDetailCacheParam.builder().code(this.bizConfigProperties.getLocationCode()).queryParent(true).lastCodeQuery(false).build());
            }
        }
        return locationInfo;
    }

    private AreaDivisionDTO convertDivision(AreaDivision areaDivision) {
        AreaDivisionDTO areaDivisionDTO = new AreaDivisionDTO();
        areaDivisionDTO.setCode(areaDivision.getCode());
        areaDivisionDTO.setLevel(areaDivision.getLevel());
        areaDivisionDTO.setName(areaDivision.getName());
        return areaDivisionDTO;
    }

    private List<LocationDTO> listHotLocation() {
        Location locationParam = new Location();
        locationParam.setHot(Byte.valueOf((byte)1));
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        return locationList.stream().map(this::convertLocation).collect(Collectors.toList());
    }

    private List<LocationDTO> listOperationLocation() {
        Location locationParam = new Location();
        locationParam.setEnableCommunityContent(Integer.valueOf(1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        return locationList.stream().map(this::convertLocation).collect(Collectors.toList());
    }

    private List<LocationDTO> listOpenedLocation() {
        List<Location> locationList = this.listOpenedLocationDetail();
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        locationDTOList.forEach(x -> x.setPinyin(x.getPinyin().substring(0, 1).toUpperCase()));
        return locationDTOList;
    }

    private List<Location> listOpenedLocationDetail() {
        Location locationParam = new Location();
        locationParam.setShow(Byte.valueOf((byte)1));
        return this.locationMapper.selectByModel(locationParam);
    }

    private LocationDTO convertLocation(Location location) {
        LocationDTO locationDTO = new LocationDTO();
        locationDTO.setCode(location.getCode());
        locationDTO.setHot(location.getHot());
        locationDTO.setLevel(location.getLevel());
        locationDTO.setName(location.getName());
        locationDTO.setPinyin(location.getPinyin().substring(0, 1).toUpperCase());
        locationDTO.setLastCode(location.getLastCode());
        locationDTO.setOrder(Integer.valueOf(location.getOrder()));
        locationDTO.setLat(location.getLat());
        locationDTO.setLng(location.getLng());
        return locationDTO;
    }

    public LocationDetailDTO getLocationDetailByCode(String code) {
        return this.getLocationDetailByCode(code, false);
    }

    public LocationDetailDTO getLocationDetailByCode(String code, boolean lastCodeQuery) {
        LocationDetailDTO locationDTO = null;
        Location location = this.locationMapper.selectByCode(code, lastCodeQuery);
        if (null != location) {
            locationDTO = new LocationDetailDTO();
            BeanUtils.copyProperties((Object)location, (Object)locationDTO);
        }
        return locationDTO;
    }

    public LocationDetailDTO getAcitivateVipLocation() {
        LocationDetailDTO locationDTO = null;
        Location location = this.locationMapper.selectActivateLocation();
        if (null != location) {
            locationDTO = new LocationDetailDTO();
            BeanUtils.copyProperties((Object)location, (Object)locationDTO);
        }
        return locationDTO;
    }

    public boolean compareLocationCode(String originalCode, List<String> standardCodeList) {
        this.logger.debug("\u53c2\u52a0\u6d3b\u52a8\u5730\u533a\u7f16\u7801\u76f8\u6bd4\u8f83\uff0c\u7528\u6237\u5730\u533a\u7f16\u53f7\uff1a{} \uff0c\u6d3b\u52a8\u5730\u533a\u5217\u8868\uff1a{}", (Object)originalCode, standardCodeList);
        if (null != originalCode && CollectionUtils.isNotEmpty(standardCodeList)) {
            String fullCode = this.completeAreaCode(originalCode);
            return standardCodeList.contains(fullCode);
        }
        return false;
    }

    public String getLocationByName(String name) {
        return this.locationMapper.selectCodeByName(name);
    }

    public void update(Location record) {
        this.locationMapper.updateByCodeSelective(record);
        this.cache.cleanUp();
        this.singleCache.cleanUp();
    }

    @Override
    public CustomerServiceDTO getCustomerServiceInfo(String code) {
        CustomerServiceDTO customerInfoCache = (CustomerServiceDTO)this.redisHashMapAdapter.get(RedisConfig.CUSTOMER_SERVICE_INFO, code, CustomerServiceDTO.class);
        if (null != customerInfoCache) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u4ee5\u5730\u533a\u7f16\u7801:{}\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u7684\u5ba2\u670d\u4fe1\u606f\u4e3a:{}", (Object)code, (Object)JSON.toJSONString((Object)customerInfoCache));
            }
            return customerInfoCache;
        }
        CustomerServiceDTO customerServiceDTO = new CustomerServiceDTO();
        Location location = this.locationMapper.selectCustomerServiceByCode(code);
        if (null == location) {
            this.logger.debug("\u6839\u636e\u533a\u57df\u7f16\u7801:{}\u83b7\u53d6\u7684\u5730\u533a\u4fe1\u606f\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u7684\u5ba2\u670d\u4fe1\u606f", (Object)code);
            customerServiceDTO.setCustomerServiceNumber(this.bizConfigProperties.getCustomerServiceNumber());
            return customerServiceDTO;
        }
        if (StringUtils.isBlank((CharSequence)location.getCustomerServiceNumber())) {
            customerServiceDTO.setCustomerServiceNumber(this.bizConfigProperties.getCustomerServiceNumber());
            customerServiceDTO.setCustomerServiceQrCode(location.getCustomerServiceQrCode());
        } else {
            customerServiceDTO.setCustomerServiceNumber(location.getCustomerServiceNumber());
            customerServiceDTO.setCustomerServiceQrCode(location.getCustomerServiceQrCode());
        }
        this.redisHashMapAdapter.put(RedisConfig.CUSTOMER_SERVICE_INFO, code, (Object)customerServiceDTO);
        return customerServiceDTO;
    }

    @Override
    public List<String> listAllLocationWithCommunity() {
        return this.locationMapper.selectLocationWithCommunity();
    }

    @Override
    public GroupCustomerPhoneDTO getGroupCustomerPhoneServiceInfo(String code) {
        GroupCustomerPhoneDTO groupCustomerPhoneCache = (GroupCustomerPhoneDTO)this.redisHashMapAdapter.get(RedisConfig.GROUP_CUSTOMER_PHONE, code, GroupCustomerPhoneDTO.class);
        if (groupCustomerPhoneCache != null) {
            this.logger.info("\u5730\u533a\uff1a{}\uff0c\u4ece\u7f13\u5b58\u4e2d\u53d6\u51fa\u56e2\u8d2d\u5ba2\u670d\u7535\u8bdd\u4fe1\u606f\uff1a{}", (Object)code, (Object)JSON.toJSONString((Object)groupCustomerPhoneCache));
            return groupCustomerPhoneCache;
        }
        GroupCustomerPhoneDTO groupCustomerPhoneDTO = new GroupCustomerPhoneDTO();
        groupCustomerPhoneDTO.setCode(code);
        Location location = this.locationMapper.selectGroupCustomPhoneByCode(code);
        if (location == null || com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)location.getGroupCustomerServicePhone())) {
            groupCustomerPhoneDTO.setGroupCustomerServicePhone(this.bizConfigProperties.getGroupCustomerPhone());
            return groupCustomerPhoneDTO;
        }
        groupCustomerPhoneDTO.setGroupCustomerServicePhone(location.getGroupCustomerServicePhone());
        this.redisHashMapAdapter.put(RedisConfig.GROUP_CUSTOMER_PHONE, code, (Object)groupCustomerPhoneDTO);
        return groupCustomerPhoneDTO;
    }

    @Override
    public OfficialAccountDTO getOfficialAccountInfo(String code) {
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)code)) {
            this.logger.warn("\u5730\u533a\u7f16\u7801\u4e3a\u7a7a");
            OfficialAccountDTO resultDTO = new OfficialAccountDTO();
            resultDTO.setCode(code);
            resultDTO.setQrCodeUrl(this.bizConfigProperties.getOfficialAccountQrcode());
            return resultDTO;
        }
        OfficialAccountDTO officialAccountCache = (OfficialAccountDTO)this.redisHashMapAdapter.get(RedisConfig.OFFICIAL_ACCOUNT_QRCODE, code, OfficialAccountDTO.class);
        if (officialAccountCache != null) {
            return officialAccountCache;
        }
        OfficialAccountDTO resultDTO = new OfficialAccountDTO();
        resultDTO.setCode(code);
        Location location = this.locationMapper.selectByCode(code, false);
        if (location == null || com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)location.getOfficialAccountQrcode())) {
            resultDTO.setQrCodeUrl(this.bizConfigProperties.getOfficialAccountQrcode());
            return resultDTO;
        }
        resultDTO.setQrCodeUrl(location.getOfficialAccountQrcode());
        this.redisHashMapAdapter.put(RedisConfig.OFFICIAL_ACCOUNT_QRCODE, code, (Object)resultDTO);
        return resultDTO;
    }

    public String completeAreaCode(String areaCode) {
        LocationDetailDTO locationDTO;
        String fullCode = areaCode;
        if (12 != fullCode.length() && null == (locationDTO = this.getLocationDetailByCode(fullCode = areaCode + "000000"))) {
            fullCode = areaCode.substring(0, 4) + "00000000";
        }
        return fullCode;
    }
}

