/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.config.SpecialUrlConfig;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.ShortLinkTypeEnum;
import com.bxm.localnews.common.dto.PrivilegeShareShortLinkDTO;
import com.bxm.localnews.common.dto.ShortBaseUrl;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.vo.BaseUrlInfo;
import com.bxm.localnews.common.vo.ShortLinkReq;
import com.bxm.localnews.thirdparty.param.RedirectToWechatMpAuthParam;
import com.bxm.localnews.thirdparty.service.WechatMpFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="shortLinkService")
public class ShortLinkServiceImpl
extends BaseService
implements ShortLinkService {
    private static final Logger log = LoggerFactory.getLogger(ShortLinkServiceImpl.class);
    private static final String SHORT = "t";
    private RedisStringAdapter redisStringAdapter;
    private BaseUrlFacadeService baseUrlFacadeService;
    private SpecialUrlConfig specialUrlConfig;

    private WechatMpFacadeService getWechatMpFacadeService() {
        return (WechatMpFacadeService)SpringContextHolder.getBean(WechatMpFacadeService.class);
    }

    public String getRegisterShortUrl(ShortLinkReq req) {
        StringBuilder url = new StringBuilder();
        String channelUrl = StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getInnerH5BaseUrl(), this.specialUrlConfig.getChannel()});
        url.append(channelUrl).append(req.getUserId());
        return this.getShortUrl(url.toString(), true);
    }

    public String getDownloadShortUrl() {
        return this.getShortUrl(StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getInnerH5BaseUrl(), this.specialUrlConfig.getDownload()}), true);
    }

    public String getFriendSweepShortUrl(ShortLinkReq req) {
        StringBuilder url = new StringBuilder();
        url.append(this.baseUrlFacadeService.getInnerH5BaseUrl()).append(this.specialUrlConfig.getFriendSweepUrl()).append(req.getUserId());
        return this.getShortUrl(url.toString(), true);
    }

    public String getMachineShortLink(String machineId) {
        String shortCode = ShortUrlGenerator.getShortUrl((String)machineId)[0];
        KeyGenerator shortKey = RedisConfig.MACHINE_SHORT_URL_KEY.copy().setKey(shortCode);
        this.redisStringAdapter.set(shortKey, (Object)machineId);
        StringBuilder sortUrl = new StringBuilder();
        sortUrl.append(this.baseUrlFacadeService.getShortLinkBaseUrl()).append("m").append("/");
        sortUrl.append(shortCode);
        return sortUrl.toString();
    }

    public String getPrivilegeShareShortLink(PrivilegeShareShortLinkDTO privilegeShareShortLinkDTO) {
        String redirectUrl = StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getContentViewSceneBaseUrl(), this.specialUrlConfig.getShareDrawActivity()});
        RedirectToWechatMpAuthParam param = new RedirectToWechatMpAuthParam();
        param.setScene(Objects.toString(DomainScene.WECHAT_AUTH));
        param.setRedirectUrl(redirectUrl);
        param.setScope("snsapi_userinfo");
        param.setState("STATE");
        return this.getShortUrl(this.getWechatMpFacadeService().wechatMpAuthUrlGen(param), true);
    }

    public String generateShortUrl(String url) {
        return this.getShortUrl(url, true);
    }

    public String generateShortUrl(String url, ShortLinkTypeEnum shortLinkType) {
        return this.getShortUrl(url, shortLinkType, true);
    }

    private String getShortUrl(String url, boolean expired) {
        return this.getShortUrl(url, ShortLinkTypeEnum.T, expired);
    }

    private String getShortUrl(String url, ShortLinkTypeEnum shortLinkType, boolean expired) {
        if (log.isDebugEnabled()) {
            this.logger.debug("\u751f\u6210\u77ed\u94fe: url: [{}] shortLinkType: {} expired: {}", new Object[]{url, shortLinkType, expired});
        }
        ShortBaseUrl shortBaseUrl = this.getShortBaseUrl(shortLinkType);
        StringBuilder sortUrl = new StringBuilder(shortBaseUrl.getBaseUrl());
        sortUrl.append(shortBaseUrl.getShortLinkType().getType()).append("/");
        String[] keys = ShortUrlGenerator.getShortUrl((String)url);
        String key = keys[0];
        if (Objects.equals(this.redisStringAdapter.hasKey(RedisConfig.SHORT_URL.copy().appendKey((Object)key)), Boolean.TRUE)) {
            key = keys[1];
        }
        sortUrl.append(key);
        if (expired) {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url, 7776000L);
        } else {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url);
        }
        return sortUrl.toString();
    }

    private ShortBaseUrl getShortBaseUrl(ShortLinkTypeEnum shortLinkType) {
        ShortLinkTypeEnum finalType;
        String baseUrl;
        if (Objects.equals(shortLinkType, ShortLinkTypeEnum.T)) {
            baseUrl = this.baseUrlFacadeService.getShortLinkBaseUrl();
            finalType = ShortLinkTypeEnum.T;
        } else {
            GetAvailableDomainInfoParam param = new GetAvailableDomainInfoParam();
            param.setScene(Objects.toString(this.getSceneByShortLinkType(shortLinkType)));
            BaseUrlInfo baseUrlInfo = this.baseUrlFacadeService.getBaseUrlInfo(param);
            if (Objects.isNull(baseUrlInfo) || StringUtils.isBlank((CharSequence)baseUrlInfo.getBaseUrl())) {
                baseUrl = this.baseUrlFacadeService.getShortLinkBaseUrl();
                finalType = ShortLinkTypeEnum.T;
            } else {
                baseUrl = baseUrlInfo.getBaseUrl();
                finalType = shortLinkType;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6e90\u7c7b\u578b: {} \u83b7\u53d6\u5230\u7684\u77ed\u94febase url: {} finalType: {}", new Object[]{shortLinkType, baseUrl, finalType});
        }
        return ShortBaseUrl.builder().baseUrl(baseUrl).shortLinkType(finalType).build();
    }

    private DomainScene getSceneByShortLinkType(ShortLinkTypeEnum shortLinkType) {
        switch (shortLinkType) {
            case WX: {
                return DomainScene.WECHAT_SHORT;
            }
        }
        return DomainScene.SHORT;
    }

    public ShortLinkServiceImpl(RedisStringAdapter redisStringAdapter, BaseUrlFacadeService baseUrlFacadeService, SpecialUrlConfig specialUrlConfig) {
        this.redisStringAdapter = redisStringAdapter;
        this.baseUrlFacadeService = baseUrlFacadeService;
        this.specialUrlConfig = specialUrlConfig;
    }
}

