/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.im.dto.ChatRoomBlockUser;
import com.bxm.localnews.im.dto.GroupInfoDto;
import com.bxm.localnews.im.enums.ChatRoomOperationEnum;
import com.bxm.localnews.im.param.ChatRoomMuteParam;
import com.bxm.localnews.im.param.ChatRoomOperationParam;
import com.bxm.localnews.im.param.MessageWithdrawParam;
import com.bxm.localnews.im.param.OperateParam;
import com.bxm.localnews.im.service.ChatRoomService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"7-03 \u7fa4\u804a\u6d88\u606f\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"{version}/im/group"})
public class ChatRoomController {
    private static final Logger log = LoggerFactory.getLogger(ChatRoomController.class);
    private final ChatRoomService chatRoomService;

    @ApiOperation(value="7-03-1 [v1]\u83b7\u53d6\u7fa4\u804a\u8be6\u60c5", notes="\u5982\u679c\u8fd4\u56de\u503c\u4e3anull\uff0c\u5219\u4e0d\u663e\u793a\u8be5\u5730\u533a\u7684\u7ea2\u5305")
    @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801")
    @GetMapping(value={"detail"})
    @ApiVersion(value=1)
    public Json<GroupInfoDto> get(@RequestParam String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.chatRoomService.getChatRoomInfoByAreaCode(areaCode));
    }

    @ApiOperation(value="7-03-2 [v1]\u804a\u5929\u5ba4\u7ba1\u7406\u5458\u64cd\u4f5c\u8bb0\u5f55", notes="")
    @PostMapping(value={"submitChatroomOperate"})
    @ApiVersion(value=1)
    public Json submitChatroomOperate(@RequestBody @Validated OperateParam operateParam) {
        this.chatRoomService.submitChatroomOperate(operateParam);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="7-03-3 [v1]\u9636\u6bb5\u7981\u8a00", notes="\u4e00\u6bb5\u65f6\u95f4\u5185\u5185\u7981\u6b62\u7528\u6237\u5728\u7fa4\u7ec4\u5185\u53d1\u8a00")
    @PostMapping(value={"block/phase"})
    @ApiVersion(value=1)
    public Json<Boolean> mutePhase(@RequestBody ChatRoomMuteParam param) {
        param.setOperationType(Integer.valueOf(ChatRoomOperationEnum.BLOCK_PHASE.getCode()));
        return Json.build((Object)this.chatRoomService.block(param).isSuccess());
    }

    @ApiOperation(value="7-03-4 [v1]\u6c38\u4e45\u7981\u8a00", notes="\u6c38\u4e45\u7981\u6b62\u7528\u6237\u5728\u7fa4\u7ec4\u5185\u53d1\u8a00")
    @PostMapping(value={"block/permanent"})
    @ApiVersion(value=1)
    public Json<Boolean> mutePermanent(@RequestBody ChatRoomOperationParam param) {
        ChatRoomMuteParam muteParam = new ChatRoomMuteParam();
        muteParam.setChatRoomId(param.getChatRoomId());
        muteParam.setTargetUserId(param.getTargetUserId());
        muteParam.setUserId(param.getUserId());
        muteParam.setOperationType(Integer.valueOf(ChatRoomOperationEnum.BLOCK_PERMANENT.getCode()));
        return Json.build((Object)this.chatRoomService.block(muteParam).isSuccess());
    }

    @ApiOperation(value="7-03-5 [v1]\u89e3\u9664\u7981\u8a00", notes="\u89e3\u9664\u7528\u6237\u5728\u7fa4\u7ec4\u4e2d\u7684\u7981\u8a00")
    @PostMapping(value={"block/remove"})
    @ApiVersion(value=1)
    public Json<Boolean> muteRelease(@RequestBody ChatRoomOperationParam param) {
        param.setOperationType(Integer.valueOf(ChatRoomOperationEnum.UNBLOCK.getCode()));
        return Json.build((Object)this.chatRoomService.unblock(param).isSuccess());
    }

    @ApiOperation(value="7-03-6 [v1]\u67e5\u8be2\u804a\u5929\u5ba4\u5df2\u88ab\u7981\u8a00\u7684\u7528\u6237", notes="\u67e5\u8be2\u804a\u5929\u5ba4\u5df2\u88ab\u7981\u8a00\u7684\u7528\u6237")
    @GetMapping(value={"block/list"})
    @ApiImplicitParam(name="chatRoomId", value="\u804a\u5929\u5ba4id")
    @ApiVersion(value=1)
    public Json<List<ChatRoomBlockUser>> muteRelease(@RequestParam(value="chatRoomId") String chatRoomId) {
        return Json.build((Object)this.chatRoomService.blockList(chatRoomId));
    }

    @ApiOperation(value="7-03-7 [v1]\u6d88\u606f\u64a4\u56de", notes="\u804a\u5929\u5ba4\u6d88\u606f\u64a4\u56de")
    @PostMapping(value={"message/withdraw"})
    public Json withdrawMessage(@RequestBody @Validated MessageWithdrawParam param) {
        log.debug("\u6d88\u606f\u64a4\u56de\u53c2\u6570:{}", (Object)param);
        Message message = this.chatRoomService.messageWithdraw(param);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)"\u6d88\u606f\u64a4\u56de\u5931\u8d25!");
    }

    @Autowired
    public ChatRoomController(ChatRoomService chatRoomService) {
        this.chatRoomService = chatRoomService;
    }
}

