/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.controller;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.im.dto.SessionInfoDto;
import com.bxm.localnews.im.service.IMService;
import com.bxm.localnews.im.service.UserBlockService;
import com.bxm.localnews.im.service.UserService;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"7-01 \u7528\u6237\u5373\u65f6\u901a\u8baf\u76f8\u5173\u64cd\u4f5c"}, description="\u5373\u65f6\u901a\u8baf\u76f8\u5173\u7684\u7528\u6237\u670d\u52a1\u63a5\u53e3")
@RestController
@RequestMapping(value={"user"})
public class UserController {
    private final IMService imService;
    private final UserBlockService userBlockService;
    private final UserService userService;

    @Autowired
    public UserController(IMService imService, UserBlockService userBlockService, UserService userService) {
        this.imService = imService;
        this.userBlockService = userBlockService;
        this.userService = userService;
    }

    @ApiOperation(value="7-01-1 \u5c4f\u853d\u3001\u89e3\u9664\u5c4f\u853d\u7528\u6237\u6d88\u606f", notes="\u9009\u62e9\u89e3\u9664\u5c4f\u853d\u3001\u5c4f\u853d\u7279\u5b9a\u7684\u7528\u6237\u65f6\uff0c\u4e0a\u62a5\u670d\u52a1\u7aef\u8fdb\u884c\u4fe1\u606f\u540c\u6b65")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5f53\u524d\u7528\u6237ID"), @ApiImplicitParam(name="blockUserId", value="\u5c4f\u853d\u7528\u6237\u7684ID"), @ApiImplicitParam(name="status", value="1:\u5c4f\u853d\uff0c0\uff1a\u89e3\u9664\u5c4f\u853d")})
    @PostMapping(value={"block"})
    public Json<Boolean> block(@RequestParam(value="userId") Long userId, @RequestParam(value="blockUserId") Long blockUserId, @RequestParam(value="status") Byte status) {
        Message message = status == 1 ? this.userBlockService.add(userId, blockUserId) : this.userBlockService.cancel(userId, blockUserId);
        return Json.build((Message)message);
    }

    @ApiOperation(value="7-01-2 \u83b7\u53d6\u5373\u65f6\u901a\u8bafSDK\u9700\u8981\u7684token\uff08\u8fd4\u56de\u503c\u7684result\u5373\u662f\uff09", notes="\u5ba2\u6237\u7aef\u53d1\u8d77\u804a\u5929\u524d\u83b7\u53d6\uff0c\u670d\u52a1\u7aef\u8fdb\u884c\u5b58\u50a8")
    @GetMapping(value={"token"})
    public Json<String> token(Long userId) {
        String token = this.imService.getToken(userId);
        if (StringUtils.isBlank((String)token)) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u7528\u6237\u4fe1\u606f\u65e0\u6548\uff0c\u53ef\u80fd\u662f\u4e34\u65f6\u7528\u6237\uff0c\u8bf7\u786e\u8ba4");
        }
        return Json.build((Object)token);
    }

    @ApiOperation(value="7-01-3 \u7528\u6237\u53d1\u8d77\u804a\u5929\u65f6\uff0c\u83b7\u53d6\u901a\u8baf\u5bf9\u8c61\u72b6\u6001", notes="\u7528\u6237\u53d1\u8d77\u804a\u5929\u65f6\uff0c\u83b7\u53d6\u4f1a\u8bdd\u72b6\u6001\uff0c\u5305\u62ec\uff1a\u662f\u5426\u53ef\u4ee5\u53d1\u9001\u3001\u662f\u5426\u5173\u6ce8\u5bf9\u65b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fromUid", value="\u53d1\u8d77\u4f1a\u8bdd\u7684\u7528\u6237\uff08\u5f53\u524d\u7528\u6237\uff09"), @ApiImplicitParam(name="toUid", value="\u4f1a\u8bdd\u76ee\u6807\u7528\u6237")})
    @GetMapping(value={"session"})
    public Json<SessionInfoDto> session(@RequestParam(value="fromUid") Long fromUid, @RequestParam(value="toUid") Long toUid) {
        return Json.build((Object)this.userService.get(fromUid, toUid));
    }
}

