package com.bxm.localnews.integration.feign;

import com.bxm.localnews.integration.feign.fallback.NewsRecommendFallbackFactory;
import com.bxm.localnews.news.dto.VideoDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-recommend", fallbackFactory = NewsRecommendFallbackFactory.class)
public interface NewsRecommendFeignService {
    @GetMapping(value = "api/news/recommendList")
    ResponseEntity<List<Long>> recommendList(@RequestParam("userId") Long userId,
                                             @RequestParam(value = "kindId", required = false) Integer kindId,
                                             @RequestParam("pageSize") Integer pageSize,
                                             @RequestParam(value = "areaCode", required = false) String areaCode);

    @GetMapping(value = "api/news/recommendByNewsDetail")
    ResponseEntity<List<Long>> recommendByNewsDetail(@RequestParam(value = "newsId") Long newsId,
                                                     @RequestParam(value = "userId") Long userId);

    @GetMapping(value = "api/video/recommendList")
    ResponseEntity<List<VideoDto>> recommendVideoList(@RequestParam(value = "userId") Long userId,
                                                      @RequestParam(value = "pageSize") Integer pageSize);
}
