package com.bxm.localnews.integration.feign;

import com.bxm.localnews.integration.feign.fallback.PushMsgSupplyFallbackFactory;
import com.bxm.localnews.mq.common.model.dto.PushAllMessage;
import com.bxm.localnews.mq.common.model.dto.PushGroupMessage;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "localnews-msg", fallbackFactory = PushMsgSupplyFallbackFactory.class)
public interface PushMsgSupplyFeignService {
    @PostMapping("/push")
    void pushMsg(@RequestBody PushMessage message);

    /**
     * 批量推送消息
     * @param pushGroupMessage 批量推送的消息
     */
    @PostMapping("/push/group")
    void pushGroupMsg(@RequestBody PushGroupMessage pushGroupMessage);

    /**
     * 推送消息到全部的用户（慎用）
     * @param pushAllMessage 全量推送
     */
    @PostMapping("/push/all")
    void pushMsgToAll(@RequestBody PushAllMessage pushAllMessage);
}
