package com.bxm.localnews.integration.feign.fallback;

import com.bxm.localnews.integration.feign.NewsRecommendFeignService;
import com.bxm.localnews.news.dto.VideoDto;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class NewsRecommendFallbackFactory implements FallbackFactory<NewsRecommendFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsRecommendFallbackFactory.class);

    @Override
    public NewsRecommendFeignService create(Throwable throwable) {
        return new NewsRecommendFeignService() {
            @Override
            public ResponseEntity<List<Long>> recommendList(Long userId, Integer kindId, Integer pageSize, String areaCode) {
                //记录请求参数
                LOGGER.error("recommendList:userId:{},kindId:{},pageSize:{},areaCode:{}", userId, kindId, pageSize, areaCode);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<Long>> recommendByNewsDetail(Long newsId, Long userId) {
                LOGGER.error("recommendByNewsDetail,newsId:{},userId:{}", newsId, userId);
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<VideoDto>> recommendVideoList(Long userId, Integer pageSize) {
                LOGGER.error("recommendVideoList,newsId:{},userId:{}", userId, pageSize);
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
