package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.InviteRecordFallbackFactory;
import com.bxm.localnews.vo.InviteRecord;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(value = "localnews-user", fallbackFactory = InviteRecordFallbackFactory.class)
public interface InviteRecordFeignService {

    @PostMapping("/facade/user/invite/updateInviteCash")
    ResponseEntity<Long> updateInviteCash(@RequestParam("userId") Long userId,
                                          @RequestParam("invitedUserId") Long invitedUserId,
                                          @RequestParam("cash") BigDecimal cash);

    @GetMapping("/facade/user/invite/getInviteRecordByInvitedUser")
    ResponseEntity<InviteRecord> getInviteRecordByInvitedUser(@RequestParam("userId") Long userId,
                                                              @RequestParam("invitedUserId") Long invitedUserId);

    @GetMapping("/facade/user/invite/getInviteRecordById")
    ResponseEntity<InviteRecord> getInviteRecordById(@RequestParam("userId") Long userId,
                                                     @RequestParam("id") Long id);
}
