package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.UserNewsFallbackFactory;
import com.bxm.localnews.vo.User;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-news", fallbackFactory = UserNewsFallbackFactory.class)
public interface UserNewsFeignService {

    //4-90-1
    @PostMapping("/facade/news/init")
    void initUserImage(@RequestParam("newUserId") Long newUserId, @RequestParam("defaultUserId") Long defaultUserId);

    //4-90-2
    @PostMapping("sync")
    void syncUser(@RequestBody User user);
}
