package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.InviteRecordFeignService;
import com.bxm.localnews.vo.InviteRecord;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@Component
public class InviteRecordFallbackFactory implements FallbackFactory<InviteRecordFeignService> {

    @Override
    public InviteRecordFeignService create(Throwable throwable) {
        return new InviteRecordFeignService() {
            @Override
            public ResponseEntity<Long> updateInviteCash(@RequestParam("userId") Long userId,
                                                         @RequestParam("invitedUserId") Long invitedUserId,
                                                         @RequestParam("cash") BigDecimal cash) {
                return ResponseEntity.ok(0L);
            }

            @Override
            public ResponseEntity<InviteRecord> getInviteRecordByInvitedUser(@RequestParam("userId") Long userId,
                                                                             @RequestParam("invitedUserId") Long invitedUserId) {
                return ResponseEntity.ok(new InviteRecord());
            }

            @Override
            public ResponseEntity<InviteRecord> getInviteRecordById(@RequestParam("userId") Long userId,
                                                                    @RequestParam("id") Long id) {
                return ResponseEntity.ok(new InviteRecord());
            }
        };
    }
}
