package com.bxm.localnews.integration;

import java.math.BigDecimal;

import com.bxm.localnews.facade.AccountFeignService;
import com.bxm.localnews.param.DeductPointParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/14 23:35
 * @desc
 */
@Service
public class AccountIntegrationService {

    @Autowired
    private AccountFeignService accountFeignService;

    public Boolean deductUserBalance(DeductPointParam deductPointParam) {
        return accountFeignService.deductUserBalance(deductPointParam).getBody();
    }

    public Boolean deductConfirmUserBalance(DeductPointParam deductPointParam) {
        return accountFeignService.deductConfirmUserBalance(deductPointParam).getBody();
    }

    public void addUserBalance(DeductPointParam deductPointParam) {
        accountFeignService.addUserBalance(deductPointParam);
    }

    public BigDecimal selectGoldBalanceByUserId(Long userId) {
        return accountFeignService.selectGoldBalanceByUserId(userId).getBody();
    }
}
