package com.bxm.localnews.integration;

import com.bxm.localnews.facade.UserNewsFeignService;
import com.bxm.localnews.vo.User;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 对facade接口进行二次封装，用于适配和兼容
 *
 * @author liujia
 */
@Service
public class UserNewsIntegrationService {

    @Autowired
    private UserNewsFeignService userNewsFeignService;

    public void initUserNewsImage(Long newUserId, Long defaultUserId) {
        userNewsFeignService.initUserImage(newUserId, defaultUserId);
    }

    public void syncUser(User user) {
        userNewsFeignService.syncUser(user);
    }
}
