/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.facade;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="localnews-user", fallbackFactory=UserFallbackFactory.class)
public interface UserFeignService {
    @GetMapping(value={"/facade/user/info"})
    public ResponseEntity<UserInfoDTO> getUserFromCache(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/facade/user/headimg"})
    public ResponseEntity<String> getDefaultHeadImgUrl();

    @GetMapping(value={"/facade/user/detail"})
    public ResponseEntity<User> selectByPrimaryKey(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"/facade/user/unionId"})
    public ResponseEntity<Boolean> checkUnionIdIsUser(@RequestParam(value="unionId") String var1);

    @PostMapping(value={"/facade/user/create"})
    public ResponseEntity<Message> createUser(@RequestBody UserParam var1);

    @PostMapping(value={"/facade/user/update"})
    public ResponseEntity<Message> updateUser(@RequestBody UserParam var1);

    @GetMapping(value={"/facade/user/temp"})
    public ResponseEntity<Boolean> isTempUser(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/facade/user/risk"})
    public ResponseEntity<Boolean> isRiskUser(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"/facade/homepage/sendSystemMessage"})
    public ResponseEntity<Boolean> sendSystemMessage(@RequestParam(value="userId") Long var1);
}

