/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.dto.UserAccountDTO;
import com.bxm.localnews.facade.UserAccountFeignService;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class UserAccountFallbackFactory
implements FallbackFactory<UserAccountFeignService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAccountFallbackFactory.class);

    public UserAccountFeignService create(final Throwable throwable) {
        return new UserAccountFeignService(){

            @Override
            public ResponseEntity<Boolean> addCash(@RequestBody AccountCashParam param) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)Boolean.FALSE);
            }

            @Override
            public ResponseEntity<BigDecimal> getUserDrawableCash(Long userId) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)BigDecimal.ZERO);
            }

            @Override
            public ResponseEntity<Message> updateUserWithdrawInfo(Long userId, BigDecimal amount, Byte withdrawState) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)Message.build((boolean)Boolean.FALSE));
            }

            @Override
            public ResponseEntity<Boolean> addGold(AccountGoldParam param) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)Boolean.FALSE);
            }

            @Override
            public ResponseEntity<BigDecimal> getUserTotalCash(Long userId) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)BigDecimal.ZERO);
            }

            @Override
            public ResponseEntity<Integer> getUserUsableGold(Long userId) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)0);
            }

            @Override
            public ResponseEntity<UserAccountDTO> getUserAccount(Long userId) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)new UserAccountDTO());
            }
        };
    }
}

