/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.service.BaseService;
import java.util.ArrayList;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushMsgIntegrationService
extends BaseService {
    @Autowired
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    @Autowired
    private BizConfigProperties bizConfigProperties;

    public void pushMsg(PushMessage pushMessage) {
        this.pushMsgSupplyFeignService.pushMsg(pushMessage);
    }

    public void pushHelpMessage(Long userId, String wechatName, Integer number) {
        String title = "\u3010VIP\u6fc0\u6d3b\u8fdb\u5ea6\u3011" + wechatName + "\u5df2\u6210\u529f\u52a9\u529b\u60a8\uff0c\u8fd8\u5dee" + number + "\u4eba\u53ef\u6fc0\u6d3bVIP";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.VIP_FRIEND_HELP);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgSupplyFeignService.pushMsg(message);
    }

    public void pushActivationVipSuccessMessage(Long userId) {
        String title = "\u606d\u559c\uff01\u60a8\u5df2\u6210\u529f\u6fc0\u6d3bVIP\u5361\uff0c\u5149\u4e34\u7ebf\u4e0b\u5408\u4f5c\u95e8\u5e97\uff0c\u7545\u4eab\u6298\u6263";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.VIP_ACTIVATION_SUCCESS);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(title);
        message.setType(TemplateTypeEnum.TRANSMISSION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgSupplyFeignService.pushMsg(message);
    }

    public void pushSignNotificationMsg(Set<Long> userIdSet) {
        PushMessage message = PushMessage.build();
        message.setTitle("\u7b7e\u5230\u63d0\u793a");
        message.setContent("\u4eca\u5929\u8fd8\u6ca1\u7b7e\u5230\u9886\u5c0f\u7ea2\u82b1\uff0c\u5feb\u6765\u6362\u7cae\u6cb9\u5927\u7c73");
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushGroup(new ArrayList<Long>(userIdSet)));
        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        pushPayloadInfo.setContent("\u4eca\u5929\u8fd8\u6ca1\u7b7e\u5230\u9886\u5c0f\u7ea2\u82b1\uff0c\u5feb\u6765\u6362\u7cae\u6cb9\u5927\u7c73");
        pushPayloadInfo.setMsgId(Long.valueOf(this.nextId()));
        pushPayloadInfo.addExtend("url", (Object)(this.bizConfigProperties.getH5ServerHost() + "/dailySign.html?userId={userId}&areaCode={areaCode}&isLogin={isLogin}&areaName={areaName}"));
        message.setPayloadInfo(pushPayloadInfo);
        this.pushMsg(message);
    }

    public Boolean addMsg(PushMessage pushMessage, Long userId) {
        return (Boolean)this.pushMsgSupplyFeignService.addMsg(pushMessage, userId).getBody();
    }
}

