/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserIntegrationService {
    @Autowired
    private UserFeignService userFeignService;
    @Autowired
    private LocationFacadeService locationFacadeService;
    @Autowired
    private BizConfigProperties bizConfigProperties;

    public UserInfoDTO getUserFromRedisDB(Long userId) {
        return (UserInfoDTO)this.userFeignService.getUserFromCache(userId).getBody();
    }

    @Cacheable(value={"getDefaultHeadImgUrl"}, sync=true)
    public String getDefaultHeadImgUrl() {
        return (String)this.userFeignService.getDefaultHeadImgUrl().getBody();
    }

    public User selectByPrimaryKey(Long userId) {
        return (User)((Object)this.userFeignService.selectByPrimaryKey(userId).getBody());
    }

    public Boolean checkUnionIdIsUser(String unionId) {
        return (Boolean)this.userFeignService.checkUnionIdIsUser(unionId).getBody();
    }

    public Message createUser(UserParam userParam) {
        return (Message)this.userFeignService.createUser(userParam).getBody();
    }

    public Message updateUser(UserParam userParam) {
        return (Message)this.userFeignService.updateUser(userParam).getBody();
    }

    public Boolean isTempUser(Long userId) {
        return (Boolean)this.userFeignService.isTempUser(userId).getBody();
    }

    public Boolean isRiskUser(Long userId) {
        return (Boolean)this.userFeignService.isRiskUser(userId).getBody();
    }

    public LocationDetailDTO getLocationByUser(User user) {
        LocationDetailDTO locationDetailDTO = null;
        if (user != null) {
            String adcode = user.getLocationCode();
            if (null != adcode) {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties((Object)this.locationFacadeService.getLocationDetailByCode(adcode), (Object)locationDetailDTO);
            } else {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties((Object)this.locationFacadeService.getLocationDetailByCode(this.bizConfigProperties.getLocationCode()), (Object)locationDetailDTO);
            }
        }
        return locationDetailDTO;
    }

    @Async
    public void sendSystemMessage(Long userId) {
        this.userFeignService.sendSystemMessage(userId);
    }
}

