package com.bxm.localnews.market.facade.controller;

import com.bxm.localnews.market.model.param.RebateUpParam;
import com.bxm.localnews.market.order.commission.impl.CommissionOrderServiceImpl;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author gonzo
 * @date 2020-12-19 16:25
 **/
@Api(tags = "10-62 内部佣金订单接口相关参数")
@RestController
@AllArgsConstructor
@RequestMapping("/facade/order/commissionOrder")
public class CommissionOrderFacadeController {

    private final CommissionOrderServiceImpl commissionOrderService;

    @ApiOperation("10-62-01 收益升级")
    @PostMapping("rebateUp")
    public ResponseEntity<Message> rebateUp(@RequestBody RebateUpParam param) {
        return ResponseEntity.ok(commissionOrderService.rebateUp(param));
    }

}
