/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.facade.controller;

import com.bxm.localnews.market.model.dto.MerchantManageOrderInfoDTO;
import com.bxm.localnews.market.model.entity.GroupOrderInfo;
import com.bxm.localnews.market.model.param.*;
import com.bxm.localnews.market.model.vo.GroupOrderInfoFacadeVO;
import com.bxm.localnews.market.order.group.GroupOrderInfoFacadeService;
import com.bxm.localnews.market.order.group.GroupPurchaseOrderFacadeService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author jieliGG
 * @date 2020/9/2 21:59
 * 用户订单信息
 **/
@Api(tags = "10-61 :【内部订单信息】")
@RestController
@AllArgsConstructor
@RequestMapping("/facade/order")
public class OrderInfoFacadeController {

    private final GroupPurchaseOrderFacadeService groupPurchaseOrderFacadeService;

    private final GroupOrderInfoFacadeService groupOrderInfoFacadeService;

    @ApiOperation("10-61-01 根据订单号获取订单详情")
    @GetMapping("/getDetailByOrderNo")
    public ResponseEntity<GroupOrderInfoFacadeVO> getDetailByOrderNo(@RequestParam("orderNo") String orderNo) {
        return ResponseEntity.ok(groupPurchaseOrderFacadeService.getOrderByOrderNo(orderNo));
    }

    @ApiOperation("10-61-02 根据订单号同意/拒绝退单")
    @GetMapping("/operatorOrder")
    public ResponseEntity<Message> operatorOrder(RefundOptionOrderParam param) {
        return ResponseEntity.ok(groupPurchaseOrderFacadeService.refundOperator(param));
    }

    @ApiOperation("10-61-03 根据核销码核销订单")
    @GetMapping("/verificationOrder")
    public ResponseEntity<Integer> verificationOrder(ConsumeOrderParam param) {
        return ResponseEntity.ok(groupPurchaseOrderFacadeService.verificationOrder(param));
    }


    @ApiOperation("10-61-04 订单支付成功回调")
    @GetMapping("/paySuccessCallback")
    public ResponseEntity<Message> paySuccessCallback(PaySuccessOrderParam param) {
        return ResponseEntity.ok(groupPurchaseOrderFacadeService.paySuccessCallback(param));
    }

    @ApiOperation("10-61-06 根据订单id查找订单信息")
    @GetMapping("/getSomeInfoById")
    public ResponseEntity<GroupOrderInfoFacadeVO> getSomeInfoById(@RequestParam("orderId") Long orderId) {
        return ResponseEntity.ok(groupOrderInfoFacadeService.getSomeInfoById(orderId));
    }

    @ApiOperation("10-61-07 用户是否存在指定商品的团购订单")
    @GetMapping("hasUserOrder")
    public ResponseEntity<Integer> hasUserOrder(@RequestParam("goodsId") Long goodsId, @RequestParam("userId") Long userId) {
        return ResponseEntity.ok(groupOrderInfoFacadeService.hasUserOrder(goodsId, userId));
    }

    @ApiOperation("10-61-08 根据商家id查询团购订单列表")
    @GetMapping("merchantOrderList")
    public ResponseEntity<PageWarper<GroupOrderInfo>> merchantOrderList(MerchantH5OrderParam param) {
        return ResponseEntity.ok(groupOrderInfoFacadeService.merchantOrderList(param));
    }

    @ApiOperation("10-61-09 根据商家id查询团购订单列表-运营后台用")
    @GetMapping("getManagePageListOrder")
    public ResponseEntity<PageWarper<MerchantManageOrderInfoDTO>> getManagePageListOrder(MerchantManageOrderParam param) {
        return ResponseEntity.ok(groupOrderInfoFacadeService.getManagePageListOrder(param));
    }

}
