/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.market.facade.controller;

import com.bxm.localnews.market.model.dto.MerchantManageOrderInfoDTO;
import com.bxm.localnews.market.model.entity.GroupOrderInfo;
import com.bxm.localnews.market.model.param.ConsumeOrderParam;
import com.bxm.localnews.market.model.param.MerchantH5OrderParam;
import com.bxm.localnews.market.model.param.MerchantManageOrderParam;
import com.bxm.localnews.market.model.param.PaySuccessOrderParam;
import com.bxm.localnews.market.model.param.RefundOptionOrderParam;
import com.bxm.localnews.market.model.vo.GroupOrderInfoFacadeVO;
import com.bxm.localnews.market.order.group.GroupOrderInfoFacadeService;
import com.bxm.localnews.market.order.group.GroupPurchaseOrderFacadeService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"10-61 :\u3010\u5185\u90e8\u8ba2\u5355\u4fe1\u606f\u3011"})
@RestController
@RequestMapping(value={"/facade/order"})
public class OrderInfoFacadeController {
    private final GroupPurchaseOrderFacadeService groupPurchaseOrderFacadeService;
    private final GroupOrderInfoFacadeService groupOrderInfoFacadeService;

    @ApiOperation(value="10-61-01 \u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/getDetailByOrderNo"})
    public ResponseEntity<GroupOrderInfoFacadeVO> getDetailByOrderNo(@RequestParam(value="orderNo") String orderNo) {
        return ResponseEntity.ok((Object)this.groupPurchaseOrderFacadeService.getOrderByOrderNo(orderNo));
    }

    @ApiOperation(value="10-61-02 \u6839\u636e\u8ba2\u5355\u53f7\u540c\u610f/\u62d2\u7edd\u9000\u5355")
    @GetMapping(value={"/operatorOrder"})
    public ResponseEntity<Message> operatorOrder(RefundOptionOrderParam param) {
        return ResponseEntity.ok((Object)this.groupPurchaseOrderFacadeService.refundOperator(param));
    }

    @ApiOperation(value="10-61-03 \u6839\u636e\u6838\u9500\u7801\u6838\u9500\u8ba2\u5355")
    @GetMapping(value={"/verificationOrder"})
    public ResponseEntity<Integer> verificationOrder(ConsumeOrderParam param) {
        return ResponseEntity.ok((Object)this.groupPurchaseOrderFacadeService.verificationOrder(param));
    }

    @ApiOperation(value="10-61-04 \u8ba2\u5355\u652f\u4ed8\u6210\u529f\u56de\u8c03")
    @GetMapping(value={"/paySuccessCallback"})
    public ResponseEntity<Message> paySuccessCallback(PaySuccessOrderParam param) {
        return ResponseEntity.ok((Object)this.groupPurchaseOrderFacadeService.paySuccessCallback(param));
    }

    @ApiOperation(value="10-61-06 \u6839\u636e\u8ba2\u5355id\u67e5\u627e\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"/getSomeInfoById"})
    public ResponseEntity<GroupOrderInfoFacadeVO> getSomeInfoById(@RequestParam(value="orderId") Long orderId) {
        return ResponseEntity.ok((Object)this.groupOrderInfoFacadeService.getSomeInfoById(orderId));
    }

    @ApiOperation(value="10-61-07 \u7528\u6237\u662f\u5426\u5b58\u5728\u6307\u5b9a\u5546\u54c1\u7684\u56e2\u8d2d\u8ba2\u5355")
    @GetMapping(value={"hasUserOrder"})
    public ResponseEntity<Integer> hasUserOrder(@RequestParam(value="goodsId") Long goodsId, @RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.groupOrderInfoFacadeService.hasUserOrder(goodsId, userId));
    }

    @ApiOperation(value="10-61-08 \u6839\u636e\u5546\u5bb6id\u67e5\u8be2\u56e2\u8d2d\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"merchantOrderList"})
    public ResponseEntity<PageWarper<GroupOrderInfo>> merchantOrderList(MerchantH5OrderParam param) {
        return ResponseEntity.ok((Object)this.groupOrderInfoFacadeService.merchantOrderList(param));
    }

    @ApiOperation(value="10-61-09 \u6839\u636e\u5546\u5bb6id\u67e5\u8be2\u56e2\u8d2d\u8ba2\u5355\u5217\u8868-\u8fd0\u8425\u540e\u53f0\u7528")
    @GetMapping(value={"getManagePageListOrder"})
    public ResponseEntity<PageWarper<MerchantManageOrderInfoDTO>> getManagePageListOrder(MerchantManageOrderParam param) {
        return ResponseEntity.ok((Object)this.groupOrderInfoFacadeService.getManagePageListOrder(param));
    }

    public OrderInfoFacadeController(GroupPurchaseOrderFacadeService groupPurchaseOrderFacadeService, GroupOrderInfoFacadeService groupOrderInfoFacadeService) {
        this.groupPurchaseOrderFacadeService = groupPurchaseOrderFacadeService;
        this.groupOrderInfoFacadeService = groupOrderInfoFacadeService;
    }
}

