/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.model.dto;

import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import lombok.Data;

/**
 * @author jieliGG
 * @date 2020/9/1 20:34
 **/
@Data
public class GoodsOrderEventDTO  {
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 商品id
     */
     private Long goodsId;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 是否开通vip ： true ： 开通
     */
    private Boolean openVip;
    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 分享人id
     */
    private Long shareUserId;

    /**
     * 返回的订单信息
     */
    private OrderInfo orderInfo;

    /**
     * 商品数量 ： 默认等于1
     * 报黄了，不让我加默认值！！！！！
     */
    private Long num = 1L;

    /**
     * 商家id ： 目前只有在核销的时候会赋值，其他地方要用的话看有么有赋值
     */
    private Long merchantId;
    /**
     * 订单操作事件
     */
    GoodsOrderEventEnum goodsOrderEventEnum;

    /**
     * 重复下单
     */
    private boolean repeatOrder;

    private String key;

    private String requestId;

    /**
     * 请求ip
     */
    private String requestIP;

}
