package com.bxm.localnews.market.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * b_market_commodity
 * @author Dong_hy
 */
@ApiModel(description = "积分商城商品信息DTO")
public class MarketCommodityDTO implements Serializable {

    @ApiModelProperty("商品id")
    private Long id;

    @ApiModelProperty("商品名称")
    private String title;

    @ApiModelProperty("商品兑换价格")
    private BigDecimal price;

    @ApiModelProperty("兑换限制次数")
    private Integer maxNum;

    @ApiModelProperty("商品类型（VIRTUAL:虚拟商品，GOODS：实物），枚举定义，后续可扩展")
    private String type;

    @ApiModelProperty("平台ID（预留字段）")
    private Long platformId;

    @ApiModelProperty("图片列表String")
    private String images;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getMaxNum() {
        return maxNum;
    }

    public void setMaxNum(Integer maxNum) {
        this.maxNum = maxNum;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }

    public String getImages() {
        return images;
    }

    public void setImages(String images) {
        this.images = images;
    }
}