package com.bxm.localnews.market.model.dto;

import lombok.Data;

import java.util.List;

/**
 * 团油订单DTO
 *
 * @author wzy
 * @date 2020/8/7 17:57
 **/
@Data
public class OilGroupOrderDTO {
    /**
     * 结果码
     */
    private Integer code;
    /**
     * 结果消息
     */
    private String message;
    /**
     * 订单信息集合
     */
    private List<Order> result;
    /**
     * 每页数量
     */
    private Integer totalRow;

    @Data
    public static class Order {
        /**
         * 订单号
         */
        private String orderId;

        /**
         * 支付号
         */
        private String paySn;

        /**
         * 手机号
         */
        private String phone;

        /**
         * 订单生成时间,时间格式 2017-09-27 00:00:00
         */
        private String orderTime;

        /**
         * 支付时间,时间格式 2017-09-27 00:00:00
         */
        private String payTime;
        /**
         * 退款时间,时间格式 2017-09-27 00:00:00
         */
        private String refundTime;
        /**
         * 油站名称
         */
        private String gasName;
        /**
         * 省名称
         */
        private String province;
        /**
         * 市名称
         */
        private String city;
        /**
         * 县名称
         */
        private String county;
        /**
         * 枪号
         */
        private Integer gunNo;

        /**
         * 油号
         */
        private String oilNo;
        /**
         * 实付金额(单位:元)
         */
        private String amountPay;

        /**
         * 订单总金额(单位:元)
         */
        private String amountGun;

        /**
         * 优惠金额(单位:元)
         */
        private String amountDiscounts;

        /**
         * 订单状态
         */
        private String orderStatusName;

        /**
         * 优惠券金额(单位:元)
         */
        private String couponMoney;

        /**
         * 优惠券 Id
         */
        private Integer couponId;

        /**
         * 优惠券 Code
         */
        private String couponCode;

        /**
         * 升数
         */
        private String litre;
        /**
         * 支付方式
         */
        private String payType;
        /**
         * 最终享受单价(单位:元)
         */
        private String priceUnit;

        /**
         * 国标价(单位:元)
         */
        private String priceOfficial;

        /**
         * 枪价(单位:元)
         */
        private String priceGun;

        /**
         * 渠道编码，对接时团油提供
         */
        private String orderSource;

        /**
         * 需要生成二维码字段(此字段如果不为空则前端以二维码 形式展示)
         */
        private String qrCode4PetroChina;
    }
}
