package com.bxm.localnews.market.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "预支付订单信息")
@Data
public class PaymentOrderDTO {

    @ApiModelProperty(value = "付款链接")
    private String link;

    @ApiModelProperty(value = "付款订单编号，可根据此订单编号查询支付状态")
    private String paymentNum;

    @ApiModelProperty(value = "预付款请求是否成功", hidden = true)
    private Boolean success;

    @ApiModelProperty(value = "当前支付对应的appid，js-api特有参数")
    private String appId;

    @ApiModelProperty(value = "时间戳参数，js-api特有参数")
    private String timeStamp;

    @ApiModelProperty(value = "随机码，js-api特有参数")
    private String nonceStr;

    @ApiModelProperty(value = "js-api特有参数")
    private String packageValue;

    @ApiModelProperty(value = "签名类型，js-api特有参数")
    private String signType;

    @ApiModelProperty(value = "支付签名，js-api特有参数")
    private String paySign;

    public PaymentOrderDTO() {
    }

    public PaymentOrderDTO(String link, String paymentNum) {
        this.link = link;
        this.paymentNum = paymentNum;
    }
}
