package com.bxm.localnews.market.model.entity;

import com.bxm.localnews.market.model.enums.OrderExtendType;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by Gonzo on 2019-07-23.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UserOrderInfoBean extends BaseBean {

    private static final long serialVersionUID = 5126052788292233821L;
    /**
     * 订单号
     */
    private String orderSn;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * 订单创建时间
     */
    private Date sourceOrderCreateTime;

    /**
     * 实际支付金额
     */
    private BigDecimal payPrice;

    /**
     * 佣金收益
     */
    private BigDecimal commission;

    /**
     * orderProfit 的type
     */
    private String type;

    /**
     * 订单来源
     */
    private String source;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 商品首图
     */
    private String imgUrl;

    /**
     * 订单所属用户ID
     */
    private Long orderOwnerUserId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 淘宝订单类型
     *
     * @see OrderTypeEnum
     */
    private String tbOrderType;

    /**
     * 订单下单类型
     *
     * @see OrderExtendType
     */
    private Byte orderSubType;

    /**
     * 第三方订单状态
     */
    private Integer sourceOwnerOrderStatus;

    /**
     * 订单返利类型（PURCHASE自购，SHARE分享）
     */
    private String orderProfitType;
}
