package com.bxm.localnews.market.model.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 肯德基在线点餐订单状态枚举
 *
 * @author wzy
 * @date 2020/8/5 22:24
 **/
@Getter
public enum KfcOrderStatusEnum {
    /**
     * 待付款
     */
    WAIT_PAYMENT(0, "待付款"),
    /**
     * 排队中
     */
    QUEUING(5, "排队中"),
    /**
     * 交易成功
     */
    SUCCESS(15, "交易成功"),
    /**
     * 已取消
     */
    CANCELLED(-5, "已取消");

    /**
     * 订单状态编码
     */
    private Integer code;
    /**
     * 订单状态描述
     */
    private String description;

    KfcOrderStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 根据code获取枚举信息
     *
     * @param code code
     * @return 枚举信息
     */
    public static KfcOrderStatusEnum of(Integer code) {
        return Stream.of(values())
                .filter(bean -> bean.code.equals(code))
                .findAny()
                .orElseThrow(() -> new IllegalArgumentException(code + " not exits"));
    }
}
