package com.bxm.localnews.market.model.enums;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 订单的下单类型
 * @author Gonzo
 * @date  2020-03-10 09:37
 * @since 1.6.0
 */
public enum OrderExtendType {

    /**
     * 默认返佣
     */
    DEFAULT((byte) 0, "默认返佣"),

    /**
     * vip 0元购
     */
    VIP_ZERO((byte) 1, "vip 0元购"),

    /**
     * 新人首单返佣
     */
    NOVICE((byte) 2, "新人首单返佣"),

    /**
     * 自定义返佣
     */
    CUSTOM((byte) 3, "自定义返佣"),

    /**
     * 饿了吗
     */
    ELE((byte) 4, "饿了吗"),

    /**
     * 饿了吗
     */
    MEITUAN_TAKE_OUT((byte) 5, "美团外卖"),
    ;

    private byte type;
    private String des;

    OrderExtendType(byte type, String des) {
        this.type = type;
        this.des = des;
    }


    public byte getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    /**
     * 根据 commissionType 获取订单拓展类型
     * @param commissionType
     * @return 订单拓展类型
     */
    public static OrderExtendType getByCommissionType(byte commissionType) {
        Optional<OrderExtendType> result = Stream.of(OrderExtendType.values())
                .filter(p -> p.getType() == commissionType)
                .findAny();

        return result.orElse(OrderExtendType.DEFAULT);

    }
}
