package com.bxm.localnews.market.model.enums;

/**
 * 订单tab的类型，我的订单和团队订单（和客户端订单列表对应）
 *
 * @author wzy
 * @date 2020年09月09日14:37:47
 */
public enum OrderTabType {
    /**
     * 我的订单
     */
    MY_ORDER_TAB(0, "我的订单"),
    /**
     * 团队订单
     */
    GROUP_ORDER_TAB(1, "团队订单");

    /**
     * code
     */
    private int code;
    /**
     * 描述信息
     */
    private String description;

    OrderTabType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
