package com.bxm.localnews.market.model.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 订单表tb_order_status订单状态枚举
 *
 * @author wzy
 * @date 2020/8/6 9:56
 * OrderTypeEnum.TMALL.name() = OrderInfo.source;
 * OrderTypeEnum.TMALL.description = OrderInfo.tbOrderType;
 * OrderTypeEnum.TMALL.code = OrderInfo.orderType;
 **/
@Getter
public enum OrderTypeEnum {
    /**
     * 天猫
     */
    TMALL(1, "天猫"),

    /**
     * 淘宝
     */
    TAOBAO(1, "淘宝"),

    /**
     * 聚划算
     */
    JUHUASUAN(1, "聚划算"),

    /**
     * 饿了么
     */
    ELE(2, "饿了么"),

    /**
     * 美团
     */
    MEITUAN(2, "美团"),

    /**
     * 淘券365卡券
     */
    TAOQUAN365(3, "淘气365"),

    /**
     * 团油
     */
    OIL_GROUP(4, "团油"),

    /**
     * 千猪KFC
     */
    QIANZHU_KFC(5, "千猪KFC"),


    /**
     * 万事通商家卖的商品 单人购买订单【3.6.0】
     * 下个版本可能有团购订单，所以这里叫做单人订单
     */
    WANSHITONG_ONE(6,"万事通商家单人订单"),

    /**
     * 订单的佣金订单
     */
    WST_ONE_COMMI(7,"单人订单的佣金订单"),
    ;


    /**
     * 订单状态编码
     */
    private Integer code;
    /**
     * 订单状态描述
     */
    private String description;

    OrderTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 根据描述信息获取枚举名称
     *
     * @param description 描述信息
     * @return 枚举名称
     */
    public static String getDescEnumName(String description) {
        OrderTypeEnum[] values = OrderTypeEnum.values();
        for (OrderTypeEnum value : values) {
            if (Objects.equals(value.description, description)) {
                return value.name();
            }
        }
        return "";
    }
}
