package com.bxm.localnews.market.model.enums;

/**
 * 收益类型
 * @author Gonzo
 * @date  2020-05-07 15:56
 * @since 2.0.0
 */
public enum ProfitTypeEnum {

    /**
     * 自购
     */
    PURCHASE("PURCHASE","自购"),
    PARENT("PARENT", "上级返利"),
    GRANDPARENT("GRANDPARENT", "上上级返利"),
    CONTENT_PARENT("CONTENT_PARENT", "内容上级返利"),
    CONTENT_GRANDPARENT("CONTENT_GRANDPARENT", "内容上上级返利"),
    SHARE("SHARE", "分享收益"),
    SERVICE("SERVICE","服务费"),
    ;

    private String code;

    private String des;


    ProfitTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }


}
