package com.bxm.localnews.market.model.enums;

import lombok.Getter;

/**
 * 淘气365卡券订单状态枚举
 *
 * @author wzy
 * @date 2020/8/5 13:41
 **/
@Getter
public enum Taoquan365OrderStatusEnum {
    /**
     * 出售成功
     */
    SOLD(1, "出售成功"),
    /**
     * 交易成功
     */
    SUCCESS(2, "交易成功"),
    /**
     * 已退款
     */
    REFUNDED(3, "已退款"),
    /**
     * 售后中
     */
    AFTER_SALE(4, "售后中"),
    /**
     * 交易关闭
     */
    EXCHANGE_CLOSE(5, "交易关闭");
    /**
     * 订单状态编码
     */
    private Integer code;
    /**
     * 订单状态描述
     */
    private String description;

    Taoquan365OrderStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }
}
