package com.bxm.localnews.market.model.vo;

import com.bxm.localnews.market.model.enums.OrderExtendType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel("团队订单信息")
@Builder
public class GroupOrderInfoVO {
    @ApiModelProperty("订单号")
    private String orderSn;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品id")
    private String goodsId;

    @ApiModelProperty("商品首图")
    private String goodsFirstImg;

    @ApiModelProperty("订单创建时间")
    private String sourceOrderCreateTime;

    @ApiModelProperty("实际支付金额 单位元")
    private BigDecimal payPrice;

    @ApiModelProperty("佣金 单位元")
    private BigDecimal commission;

    @ApiModelProperty("订单类型")
    private String orderTypeName;

    @ApiModelProperty("订单来源 TB：淘宝")
    private String source;

    @ApiModelProperty("订单状态  0：待结算|1：已结算|2：已失效")
    private Integer orderStatus;

    @ApiModelProperty("好友昵称")
    private String friendNick;

    @ApiModelProperty("好友佣金")
    private BigDecimal friendCommission;

    @ApiModelProperty("好友头像")
    private String imgUrl;

    @ApiModelProperty("商品优惠券")
    private BigDecimal coupon;

    @ApiModelProperty("隐私状态，1:开启，-1:关闭")
    private Integer type;

    @ApiModelProperty("是否好友订单，0-非好友订单，1-好友订单")
    private Integer friendOrder;

    @ApiModelProperty("邀请0元购标签：INVITE_ZERO 、首单福利标签：FIRST_ORDER")
    private String label;

    @ApiModelProperty(value = "订单所属平台类型，包括天猫、淘宝、聚划算、饿了吗，美团，淘券365卡券，团油，千猪KFC，万事通商家单人订单等",
            example = "TMALL, TAOBAO, ELE, MEITUAN, TAOQUAN365，OIL_GROUP，QIANZHU_KFC，WANSHITONG_ONE")
    private String orderType;

    @ApiModelProperty("订单数量")
    private Integer num;

    /**
     * @see OrderExtendType
     */
    @ApiModelProperty(value = "订单下单类型", example = "订单类型 0 默认类型（就是一些暂未区分出来的统一类型）1 vip0元购订单 2 新人首单返佣订单")
    private Byte orderSubType;

    @ApiModelProperty(value = "是否确认收货，目前只针对淘宝订单", example = "true确认收货，false未确认收货")
    private Boolean confirmReceived;

    @ApiModelProperty(value = "预计结算时间，只有当确认收货以后才会有这个时间",
            example = "如：2020/09/01 16:30")
    private String expectSettlementTime;

    @ApiModelProperty(value = "订单级别", example = "1:一级徒弟的订单， 2：二级徒弟的订单")
    private Integer orderLevel;

    @ApiModelProperty(value = "订单title")
    private String orderTitle;

    @ApiModelProperty(value = "logo图标地址")
    private String logoUrl;

    @ApiModelProperty(value = "订单详情跳转地址", example = "订单详情跳转地址")
    private String thirdPartyFindUrl;
}
