package com.bxm.localnews.market.model.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * b_market_order
 * @author 
 */
public class MarketOrder implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 订单编号(yyyymmdd000000000) (每日编号从1自增)
     */
    private String orderNo;

    /**
     * 发起订单的用户ID
     */
    private Long userId;

    /**
     * 订单所属用户名称
     */
    private String userName;

    /**
     * 订单所属平台ID（预留字段）
     */
    private Long platformId;

    /**
     * 商品ID
     */
    private Long commodityId;

    /**
     * 商品名称(生成订单时的名称)
     */
    private String commodityTitle;

    /**
     * 商品图片
     */
    private String commodityImages;

    /**
     * 商品兑换价格（生成订单时的价格）
     */
    private BigDecimal commodityPrice;

    /**
     * 0-已完成，1-失败，2-处理中
     */
    private Integer status;

    /**
     * 收货地址ID
     */
    private Long addressId;

    /**
     * 完整收货地址（与地址表同步）
     */
    private String finalAddress;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 物流公司名称
     */
    private String expressageCompany;

    /**
     * 物流单编号
     */
    private String expressageNo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }

    public Long getCommodityId() {
        return commodityId;
    }

    public void setCommodityId(Long commodityId) {
        this.commodityId = commodityId;
    }

    public String getCommodityTitle() {
        return commodityTitle;
    }

    public void setCommodityTitle(String commodityTitle) {
        this.commodityTitle = commodityTitle;
    }

    public String getCommodityImages() {
        return commodityImages;
    }

    public void setCommodityImages(String commodityImages) {
        this.commodityImages = commodityImages;
    }

    public BigDecimal getCommodityPrice() {
        return commodityPrice;
    }

    public void setCommodityPrice(BigDecimal commodityPrice) {
        this.commodityPrice = commodityPrice;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getAddressId() {
        return addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }

    public String getFinalAddress() {
        return finalAddress;
    }

    public void setFinalAddress(String finalAddress) {
        this.finalAddress = finalAddress;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getExpressageCompany() {
        return expressageCompany;
    }

    public void setExpressageCompany(String expressageCompany) {
        this.expressageCompany = expressageCompany;
    }

    public String getExpressageNo() {
        return expressageNo;
    }

    public void setExpressageNo(String expressageNo) {
        this.expressageNo = expressageNo;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}