package com.bxm.localnews.market.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author wzy
 * @date 2020年09月01日15:27:11
 */
@Data
@ApiModel(description = "各个订单类型对应的订单数量")
public class OrderStatusCountVO {

    @ApiModelProperty(value = "订单状态",
            example = "订单状态 1：待结算|2：已结算|3：失效 4:待付款 5：待使用 6：退款/售后")
    private Integer orderStatus;

    @ApiModelProperty(value = "对应订单状态下的订单数量")
    private Integer orderCount;
}
