/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.market.model.enums;

import java.util.Objects;
import java.util.stream.Stream;

public enum OilGroupOrderStatusEnum {
    HAS_PAYMENT(1, "\u5df2\u652f\u4ed8"),
    REFUND_APPLYING(4, "\u9000\u6b3e\u7533\u8bf7\u4e2d"),
    HAS_REFUND(5, "\u5df2\u7ecf\u9000\u6b3e"),
    REFUND_FAIL(6, "\u9000\u6b3e\u5931\u8d25");

    private Integer code;
    private String description;

    private OilGroupOrderStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static OilGroupOrderStatusEnum of(String description) {
        Objects.requireNonNull(description);
        return Stream.of(OilGroupOrderStatusEnum.values()).filter(bean -> bean.description.equals(description)).findAny().orElseThrow(() -> new IllegalArgumentException(description + " is not exist"));
    }

    public static OilGroupOrderStatusEnum of(Integer code) {
        Objects.requireNonNull(code);
        return Stream.of(OilGroupOrderStatusEnum.values()).filter(bean -> bean.code.equals(code)).findAny().orElseThrow(() -> new IllegalArgumentException(code + " is not exist"));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

