/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.market.model.enums;

import java.util.Optional;
import java.util.stream.Stream;

public enum OrderExtendType {
    DEFAULT(0, "\u9ed8\u8ba4\u8fd4\u4f63"),
    VIP_ZERO(1, "vip 0\u5143\u8d2d"),
    NOVICE(2, "\u65b0\u4eba\u9996\u5355\u8fd4\u4f63"),
    CUSTOM(3, "\u81ea\u5b9a\u4e49\u8fd4\u4f63"),
    ELE(4, "\u997f\u4e86\u5417"),
    MEITUAN_TAKE_OUT(5, "\u7f8e\u56e2\u5916\u5356");

    private byte type;
    private String des;

    private OrderExtendType(byte type, String des) {
        this.type = type;
        this.des = des;
    }

    public byte getType() {
        return this.type;
    }

    public String getDes() {
        return this.des;
    }

    public static OrderExtendType getByCommissionType(byte commissionType) {
        Optional<OrderExtendType> result = Stream.of(OrderExtendType.values()).filter(p -> p.getType() == commissionType).findAny();
        return result.orElse(DEFAULT);
    }
}

