package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.activity.LotteryDetailFacadeDTO;
import com.bxm.localnews.merchant.service.lottery.LotteryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.ibatis.annotations.Param;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/10/27 6:24 下午
 */
@Api(tags = "11-92 [内部接口] 夺宝相关接口")
@RequestMapping("facade/merchant/lottery")
@RestController
public class LotteryFacadeController {

    private final LotteryService lotteryService;

    public LotteryFacadeController(LotteryService lotteryService) {
        this.lotteryService = lotteryService;
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @ApiOperation(value = "11-92-01 获取可用的最新夺宝活动信息", notes = "如果返回null则表示没有任何夺宝活动")
    @GetMapping("getLotteryInfo")
    public ResponseEntity<LotteryDetailFacadeDTO> getUserLotteryInfo(@Param("areaCode") String areaCode) {
        return ResponseEntity.ok(lotteryService.queryLastEnableLotteryInfo(areaCode));
    }
}