package com.bxm.localnews.merchant.service.activity.impl;

import com.bxm.localnews.merchant.dto.ActionRecordTraceIdDTO;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.param.MerchantReportParam;
import com.bxm.localnews.merchant.param.activity.ActivityAdvertParam;
import com.bxm.localnews.merchant.security.facade.dto.RelationshipDto;
import com.bxm.localnews.merchant.security.facade.service.MerchantMemberFacadeService;
import com.bxm.localnews.merchant.service.activity.ActivityService;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.bxm.localnews.merchant.service.activity.ticket.TicketHandlerChain;
import com.bxm.localnews.merchant.service.count.MerchantActionRecordService;
import com.bxm.localnews.merchant.service.count.MerchantPageCollectService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author pf.w
 * @date 2020/8/5 10:56
 **/
@Service
@Log4j2
@AllArgsConstructor
public class ActivityServiceImpl implements ActivityService {

    private MerchantMemberFacadeService merchantMemberFacadeService;

    private TicketHandlerChain ticketHandlerChain;

    private MerchantActionRecordService merchantActionRecordService;

    private MerchantPageCollectService merchantPageCollectService;


    @Override
    public ActivityAdvertInfoDTO activityAdvertUp(ActivityAdvertParam param) {

        if (log.isDebugEnabled()) {
            log.debug("ActivityAdvertParam : {}", param);
        }

        if (Objects.isNull(param.getShareUserId())) {
            return null;
        }

        //获取链路ID
        String traceId = this.traceIdDo(param);
        //统计浏览pv
        this.viewContent(param, traceId);

        RelationshipDto relationshipDto = merchantMemberFacadeService.getRelationship(param.getShareUserId());

        //没有团队信息时直接返回
//        if (Objects.isNull(relationshipDto)) {
//            return null;
//        }

        return ticketHandlerChain.excuter(makeTicketContext(param, relationshipDto, traceId));
    }

    private TicketContext makeTicketContext(ActivityAdvertParam param, RelationshipDto relationshipDto, String traceId) {
        TicketContext ticketContext = TicketContext.builder()
                .merchantId(Objects.nonNull(relationshipDto) ? relationshipDto.getMerchantId() : null)
                .traceId(traceId)
                .build();
        BeanUtils.copyProperties(param, ticketContext);
        return ticketContext;
    }

    /**
     * 增加点击pv
     *
     * @param param   广告接口参数
     * @param traceId 链路ID
     */
    private void viewContent(ActivityAdvertParam param, String traceId) {
        if (StringUtils.isBlank(param.getActorUserId())) {
            return;
        }
        MerchantReportParam merchantReportParam = new MerchantReportParam();
        merchantReportParam.setTraceId(traceId);
        merchantReportParam.setToken(param.getActorUserId());
        merchantPageCollectService.viewContent(merchantReportParam);
    }

    /**
     * 获取分享-点击-浏览-订单 整个逻辑链路的id
     *
     * @param param 广告接口参数
     * @return 链路ID
     */
    private String traceIdDo(ActivityAdvertParam param) {

        ActionRecordTraceIdDTO actionRecordTraceIdDTO = new ActionRecordTraceIdDTO();
        actionRecordTraceIdDTO.setBelonger(param.getShareUserId());
        actionRecordTraceIdDTO.setRelationId(param.getContentId());
        actionRecordTraceIdDTO.setRelationType(param.getContentType());
        String traceId = merchantActionRecordService.getTraceByRidBelonger(actionRecordTraceIdDTO);

        if (log.isDebugEnabled()) {
            log.debug("traceIdDo  traceId : {}", traceId);
        }

        return StringUtils.isNotBlank(traceId) ? traceId : null;
    }
}
