package com.bxm.localnews.merchant.service.activity.ticket;

import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author pf.w
 * @date 2020/8/4 17:00
 **/
@Component
public class TicketHandlerChain {

    private Map<Integer, AbstractTicketHandler> handlerMap;

    /**
     * 责任链中的处理器优先级排序集合
     */
    private List<Integer> offsets = new ArrayList<>();

    @Autowired
    public TicketHandlerChain(List<AbstractTicketHandler> processors) {

        handlerMap = Maps.newHashMap();

        if (null != processors) {

            processors.forEach(processor -> {
                offsets.add(processor.getHandlerLevel());
                handlerMap.put(processor.getHandlerLevel(), processor);
            });

            //执行级别排序
            offsets.sort(Integer::compareTo);

            //指定下一个执行链
            handlerMap.forEach((k, v) -> {
                int size = offsets.size() - 1;
                int index = offsets.indexOf(k);
                if (size > index) {
                    v.setNextHandler(handlerMap.get(offsets.get(index + 1)));
                }
            });

        }
    }

    /**
     * 处理器执行类
     *
     * @param request
     */
    public ActivityAdvertInfoDTO excuter(TicketContext request) {
        return handlerMap.get(offsets.get(0)).handlerMessage(request);
    }
}
