package com.bxm.localnews.merchant.service.activity.ticket.processor;

import com.bxm.localnews.merchant.common.constant.TicketLevelEnum;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.service.activity.ticket.AbstractTicketHandler;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.bxm.localnews.merchants.dto.MerchantAdvertInfoDTO;
import com.bxm.localnews.merchants.facade.service.MerchantInfoAdvertFacade;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 *
 * 商家配置过广告券直接出券
 *
 * @author pf.w
 * @date 2020/8/4 17:50
 **/
@Component
@AllArgsConstructor
public class DeployHandlerProcessor extends AbstractTicketHandler {

    MerchantInfoAdvertFacade merchantInfoManageService;

    @Override
    protected int getHandlerLevel() {
        return TicketLevelEnum.CONFIGURE_LEVEL.getNum();
    }

    @Override
    protected ActivityAdvertInfoDTO response(TicketContext context) {
        if (Objects.isNull(context.getMerchantId())) {
            return null;
        }

        MerchantAdvertInfoDTO merchantAdvertInfoDTO = merchantInfoManageService.merchantAdvertInfo(context.getMerchantId());

        if (Objects.isNull(merchantAdvertInfoDTO) || merchantAdvertInfoDTO.getStatus() == 0) {
            return null;
        }

        ActivityAdvertInfoDTO response = new ActivityAdvertInfoDTO();
        response.setImgUrl(merchantAdvertInfoDTO.getImgUrl());
        response.setActivityType(TicketLevelEnum.CONFIGURE_LEVEL.getCode());
        response.setLinkUrl(merchantAdvertInfoDTO.getLinkUrl());
        response.setTitle(merchantAdvertInfoDTO.getTitle());
        response.setTraceId(context.getTraceId());
        return response;
    }
}
