package com.bxm.localnews.merchant.service.activity.ticket.processor;

import com.bxm.localnews.merchant.common.constant.TicketLevelEnum;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.integration.ForumPostIntegrationService;
import com.bxm.localnews.merchant.service.activity.ticket.AbstractTicketHandler;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author pf.w
 * @date 2020/12/15 16:48
 **/
@Component
public class TopicHandlerProcessor extends AbstractTicketHandler {

    @Resource
    private ForumPostIntegrationService forumPostIntegrationService;

    private static final String CONTEXT_TYPE = "FORUM";

    @Override
    protected int getHandlerLevel() {
        return TicketLevelEnum.FORUM_TOPIC.getNum();
    }

    @Override
    protected ActivityAdvertInfoDTO response(TicketContext context) {
        if (!Objects.equals(context.getContentType(), CONTEXT_TYPE) || Objects.isNull(context.getContentId())) {
            return null;
        }

        TopicFacadeVO topicFacadeVO = forumPostIntegrationService.getTopicInfoByForumId(context.getContentId());

        return Objects.isNull(topicFacadeVO) ? null : convert(topicFacadeVO);
    }

    private ActivityAdvertInfoDTO convert(TopicFacadeVO topicFacadeVO) {
        ActivityAdvertInfoDTO result = new ActivityAdvertInfoDTO();
        result.setLogicId(topicFacadeVO.getId());
        result.setTitle(topicFacadeVO.getTitle());
        result.setSubtitle(topicFacadeVO.getDescp());
        result.setExtDate(topicFacadeVO.getParticipantsNum().toString());
        result.setActivityType(TicketLevelEnum.FORUM_TOPIC.getCode());
        result.setImgUrl(topicFacadeVO.getImg());
        result.setLinkUrl(linkUrl());
        return result;
    }

    private String linkUrl() {
        return "${common.config.h5-enabled-domain-name}/shareTopicDetail.html?userId={userId}&id={id}&cityName={cityName}&areaName={areaName}&areaCode={areaCode}";
    }
}
