package com.bxm.localnews.merchant.service.activity.ticket.processor;

import com.bxm.localnews.merchant.common.constant.TicketLevelEnum;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.service.activity.ticket.AbstractTicketHandler;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Objects;

/**
 * 未配置广告的商家取商家的微官网
 *
 * @author pf.w
 * @date 2020/8/4 17:51
 **/
@Component
@AllArgsConstructor
public class WebsiteHandlerProcessor extends AbstractTicketHandler {

    MerchantInfoMapper merchantInfoMapper;

    private final MerchantInfoFacadeService merchantInfoDbService;

    @Override
    protected int getHandlerLevel() {
        return TicketLevelEnum.WEBSITE_LEVEL.getNum();
    }

    @Override
    protected ActivityAdvertInfoDTO response(TicketContext context) {

        if (Objects.isNull(context.getMerchantId())) {
            return null;
        }

        //获取详情
        MerchantInfo merchantInfo = merchantInfoDbService.getMerchantInfo(context.getMerchantId());

        //null 或者 下架的商家都不出券
        if (Objects.isNull(merchantInfo) || merchantInfo.getIsShelf() != 1) {
            return null;
        }

        ActivityAdvertInfoDTO response = new ActivityAdvertInfoDTO();
        response.setTraceId(context.getTraceId());
        response.setTitle(merchantInfo.getManageName());
        response.setImgUrl(StringUtils.isNotBlank(merchantInfo.getHeadPics()) ? Arrays.asList(merchantInfo.getHeadPics
                ().split(",")).get(0) : null);
        response.setActivityType(TicketLevelEnum.WEBSITE_LEVEL.getCode());
        response.setLinkUrl(linkUrl(context, response.getTraceId()));
        response.setSubtitle(merchantInfo.getDes());

        return response;
    }

    private String linkUrl(TicketContext param, String traceId) {
        //是否需要写到外部？。。算了，没必要，单一逻辑，还得配置两个通配符
        String linkUrl = "${common.config.h5-enabled-domain-name}/shareShopDetail.html?merchantId=" + param.getMerchantId() + "&traceId=" + traceId + "&shareUserId=" + param.getShareUserId() + "&actorUserId=" + param.getActorUserId() + "&userId={userId}&areaCode={areaCode}&cityName={cityName}&areaName={areaName}&longitude={longitude}&latitude={latitude}";
        return linkUrl;
    }
}