package com.bxm.localnews.merchant.service.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * @author liujia
 * @date 2020-10-27 17:38
 **/
@Data
@Component
@ConfigurationProperties(prefix = "merchant.config.activity")
public class ActivityProperties {

    /**
     * 参与夺宝活动自动关注商家
     * true：表示自动关注，false则需要用户通过弹窗人工确认
     */
    private Boolean enableAutoFollow = true;

    /**
     * 用户参与夺宝活动的夺宝券的起始值
     */
    private Long joinCodeStartIndex = 10000000L;

    /**
     * 真实用户开奖的活动，最少需要多少个真实用户参与
     */
    private Integer minimumActual = 10;

    /**
     * 马甲号参与夺宝半小时内最少参与人数
     */
    private Integer halfHourMinNum = 15;

    /**
     * 马甲号参与夺宝半小时内最多参与人数
     */
    private Integer halfHourMaxNum = 30;

    /**
     * 新用户（注册日期为今日）可免费参与夺宝活动的次数
     */
    private Integer freeTimes = 2;

    /**
     * 站外增加夺宝券是否需要强制匹配互动期数ID
     */
    private Boolean matchPhaseId = true;

    /**
     * 炫耀帖子文案
     */
    private List<String> flauntTexts = Collections.singletonList("我在夺宝活动中中奖啦！获得了“%s“，美滋滋~友友们，快一起来参与呀！");

    /**
     * 炫耀帖子跳转链接
     */
    private String extraContentElement = "<a wst-lottery-flaunt-href='%s'>%s</a>";

    /**
     * 炫耀帖子跳转链接
     */
    private List<String> extraContents = Collections.singletonList("点击参与夺宝");

    /**
     * 炫耀帖子的话题id
     */
    private Long flauntTopicId = 1234567L;

    /**
     * 不限制站外参与次数开关
     */
    private Boolean noLimitWebJoinTimes = false;


    /**
     * 公众号推送获取夺宝码最大数量
     */
    private Integer maxCodeSize = 5;
}
