package com.bxm.localnews.merchant.service.enums;

/**
 * 参与夺宝活动的结果
 *
 * @author liujia
 * @date 2020-10-27 17:25
 **/
public enum LotteryJoinResultEnum {

    /**
     * 参与成功
     */
    SUCCESS(1),

    /**
     * 用户参与次数达到上限
     */
    MAX_TIMES(2),

    /**
     * 小红花不足
     */
    GOLD_NOT_ENOUGH(3),

    /**
     * 活动已结束
     */
    FINISH(4),

    /**
     * 用户未关注商家
     */
    UNFOLLOW(5);

    private Integer code;

    public Integer getCode() {
        return code;
    }

    LotteryJoinResultEnum(Integer code) {
        this.code = code;
    }
}
