package com.bxm.localnews.merchant.service.enums;

/**
 * 参与夺宝活动的来源
 *
 * @author liujia
 * @date 2020-10-28 09:59
 **/
public enum LotteryJoinSourceEnum {

    /**
     * APP内参与
     */
    APP(1),

    /**
     * 站外直接参与
     */
    WEB(2),

    /**
     * 通过邀请好友成功获得的参与机会
     */
    INVITE(3),

    /**
     * 虚拟用户参与
     */
    VIRTUAL(4);

    private Integer code;

    public Integer getCode() {
        return code;
    }

    LotteryJoinSourceEnum(Integer code) {
        this.code = code;
    }
}
