package com.bxm.localnews.merchant.service.enums;

/**
 * 夺宝活动期数状态枚举
 *
 * @author liujia
 * @date 2020-10-27 11:42
 **/
public enum LotteryPhaseStatusEnum {

    /**
     * 夺宝活动进行中
     */
    GOING(1),

    /**
     * 夺宝活动已结束
     */
    FINISH(2),

    /**
     * 夺宝活动已取消（还可以再次开启）
     */
    CANCEL(3);

    private Integer code;

    public Integer getCode() {
        return code;
    }

    LotteryPhaseStatusEnum(Integer code) {
        this.code = code;
    }
}
