package com.bxm.localnews.merchant.service.enums;

/**
 * 夺宝活动状态
 *
 * @author liujia
 * @date 2020-10-26 19:21
 **/
public enum LotteryStatusEnum {
    /**
     * 等待投放（未到达活动开启时间）
     */
    UNDER_PLANNING(0),

    /**
     * 活动开启中
     */
    ACTIVED(1),

    /**
     * 活动已结束
     */
    FINISH(2),

    /**
     * 活动对应的奖品库存不足
     */
    STOCK_OVER(3),

    /**
     * 活动对应的奖品已到期
     */
    EXPIRED(4),

    /**
     * 活动已删除
     */
    DELETED(5),

    /**
     * 运营手工下线
     */
    OFFLINE(6),

    /**
     * 商户下线
     */
    MERCHANT_OFFLINE(7),
    ;

    private Integer code;

    public Integer getCode() {
        return code;
    }

    LotteryStatusEnum(Integer code) {
        this.code = code;
    }
}
