package com.bxm.localnews.merchant.service.enums;

/**
 * 用于返回给前端的奖品使用状态的枚举，用于商家中心夺宝吸粉
 */
public enum UseStatusEnum {
    /**
     * 已核销
     */
    HAVE_CHECK(1),
    /**
     * 待核销
     */
    NOT_CHECK(2),
    /**
     * 已发奖
     */
    HAVE_AWARD(3),
    /**
     * 未发奖
     */
    NOT_AWARD(4),
    /**
     * 已下架
     */
    OFFLINE(5);

    UseStatusEnum(int code) {
        this.code = code;
    }

    private int code;

    public int getCode() {
        return code;
    }
}
