package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.ActivityTrackOverviewDTO;
import com.bxm.localnews.merchant.param.activity.ActivityTrackManageParam;
import com.bxm.localnews.merchant.param.activity.ActivityTrackParam;
import com.bxm.localnews.merchant.param.activity.ChangeTrackRemarkParam;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 夺宝商家赞助活动线索Service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2020/10/26 2:29 下午
 */
public interface ActivityTrackService {

    /**
     * 新增商家赞助线索
     *
     * @param param 请求入参
     */
    void addTrack(ActivityTrackParam param);

    /**
     * 分页查询商家赞助意向信息
     *
     * @param param 查询入参
     * @return 分页数据
     */
    PageWarper<ActivityTrackOverviewDTO> queryByPage(ActivityTrackManageParam param);

    /**
     * 更新商家赞助线索的备注
     *
     * @param param 更新入参
     */
    void modifyRemark(ChangeTrackRemarkParam param);
}